/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.utils;

import me.loving11ish.epichomes.libs.adventure.adventure.text.Component;
import me.loving11ish.epichomes.libs.adventure.adventure.text.minimessage.MiniMessage;
import me.loving11ish.epichomes.libs.adventure.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;

public class ColorUtils {
    public static final String WITH_DELIMITER = "((?<=%1$s)|(?=%1$s))";

    public static String translateColorCodes(String text) {
        if (ColorUtils.containsMiniMessageTags(text)) {
            MiniMessage miniMessage = MiniMessage.miniMessage();
            Object component = miniMessage.deserialize(text);
            return LegacyComponentSerializer.legacySection().serialize((Component)component);
        }
        String[] texts = text.split(String.format(WITH_DELIMITER, "&"));
        StringBuilder finalText = new StringBuilder();
        for (int i = 0; i < texts.length; ++i) {
            if (texts[i].equalsIgnoreCase("&")) {
                if (texts[++i].charAt(0) == '#') {
                    finalText.append(String.valueOf(net.md_5.bungee.api.ChatColor.of((String)texts[i].substring(0, 7))) + texts[i].substring(7));
                    continue;
                }
                finalText.append(ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + texts[i])));
                continue;
            }
            finalText.append(texts[i]);
        }
        return finalText.toString();
    }

    private static boolean containsMiniMessageTags(String text) {
        return text.matches(".*<(red|green|blue|bold|italic|reset|underlined|hover|click|obfuscated).*>");
    }

    public static String stripColorCodes(String text) {
        String legacyColorPattern = "(?i)[&\u00a7][0-9A-FK-OR]";
        String hexColorPattern = "(?i)#[A-F0-9]{6}";
        String miniMessagePattern = "<[^>]+>";
        String combinedPattern = String.format("%s|%s|%s", legacyColorPattern, hexColorPattern, miniMessagePattern);
        return text.replaceAll(combinedPattern, "");
    }
}

