/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.menusystem.paginatedmenus;

import java.util.ArrayList;
import java.util.List;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.api.events.AsyncHomePreTeleportEvent;
import me.loving11ish.epichomes.libs.folialib.FoliaLib;
import me.loving11ish.epichomes.menusystem.PaginatedMenu;
import me.loving11ish.epichomes.menusystem.PlayerMenuUtility;
import me.loving11ish.epichomes.menusystem.menus.DeleteSingleGUI;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.ColorUtils;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.TeleportationUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HomeListGUI
extends PaginatedMenu {
    private final FoliaLib foliaLib = EpicHomes.getFoliaLib();
    private static final String HOME_NAME_PLACEHOLDER = "%HOME%";
    private static final String HOME_LOCATION_PLACEHOLDER_WORLD = "%LOCATION-WORLD%";
    private static final String HOME_LOCATION_PLACEHOLDER_X = "%LOCATION-X%";
    private static final String HOME_LOCATION_PLACEHOLDER_Y = "%LOCATION-Y%";
    private static final String HOME_LOCATION_PLACEHOLDER_Z = "%LOCATION-Z%";
    private final UsermapStorageUtil usermapStorageUtil = EpicHomes.getPlugin().getUsermapStorageUtil();

    public HomeListGUI(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getHomeListGUITitle());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent event) {
        String homeName;
        Player player = (Player)event.getWhoClicked();
        User user = this.usermapStorageUtil.getUserByOnlinePlayer(player);
        List<String> userHomesList = this.usermapStorageUtil.getHomeNamesListByUser(user);
        this.playerMenuUtility.setUser(user);
        if (event.isLeftClick()) {
            if (event.getCurrentItem().getType().equals((Object)EpicHomes.getPlugin().getConfigManager().getHomeListGUIItemMaterial())) {
                String homeName2 = (String)event.getCurrentItem().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)EpicHomes.getPlugin(), "homeName"), PersistentDataType.STRING);
                if (homeName2 != null) {
                    Location homeLocation = this.usermapStorageUtil.getHomeLocationByHomeName(user, homeName2);
                    this.playerMenuUtility.setHomeName(homeName2);
                    this.playerMenuUtility.setHomeLocation(homeLocation);
                    if (EpicHomes.getPlugin().getConfigManager().isUseDelayBeforeHomeTP()) {
                        TeleportationUtils teleportationUtils = new TeleportationUtils();
                        this.foliaLib.getScheduler().runAsync(task -> {
                            HomeListGUI.fireHomePreTeleportEvent(player, user, homeName2, homeLocation, player.getLocation());
                            MessageUtils.sendDebugConsole("&aFired AsyncHomePreTeleportEvent");
                        });
                        teleportationUtils.teleportPlayerAsyncTimed(player, homeLocation, homeName2);
                        player.closeInventory();
                    } else {
                        TeleportationUtils teleportationUtils = new TeleportationUtils();
                        this.foliaLib.getScheduler().runAsync(task -> {
                            HomeListGUI.fireHomePreTeleportEvent(player, user, homeName2, homeLocation, player.getLocation());
                            MessageUtils.sendDebugConsole("&aFired AsyncHomePreTeleportEvent");
                        });
                        teleportationUtils.teleportPlayerAsync(player, homeLocation, homeName2);
                        player.closeInventory();
                    }
                }
            } else if (event.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
                player.closeInventory();
            } else if (event.getCurrentItem().getType().equals((Object)Material.STONE_BUTTON)) {
                if (event.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getMenuPreviousPageItemName()))) {
                    if (this.page == 0) {
                        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getGuiFirstPage());
                    } else {
                        --this.page;
                        super.open();
                    }
                } else if (event.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getMenuNextPageItemName()))) {
                    if (this.index + 1 < userHomesList.size()) {
                        ++this.page;
                        super.open();
                    } else {
                        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getGuiLastPage());
                    }
                }
            }
        } else if (event.isRightClick() && event.getCurrentItem().getType().equals((Object)EpicHomes.getPlugin().getConfigManager().getHomeListGUIItemMaterial()) && (homeName = (String)event.getCurrentItem().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)EpicHomes.getPlugin(), "homeName"), PersistentDataType.STRING)) != null) {
            this.playerMenuUtility.setHomeName(homeName);
            this.playerMenuUtility.setHomeLocation(this.usermapStorageUtil.getHomeLocationByHomeName(user, homeName));
            new DeleteSingleGUI(this.playerMenuUtility).open();
        }
    }

    @Override
    public void setMenuItems() {
        this.addMenuControls();
        User user = this.usermapStorageUtil.getUserByOnlinePlayer(this.playerMenuUtility.getOwner());
        List<String> userHomesList = this.usermapStorageUtil.getHomeNamesListByUser(user);
        if (userHomesList != null && !userHomesList.isEmpty()) {
            for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index >= userHomesList.size()) break;
                if (userHomesList.get(this.index) == null) continue;
                String homeName = userHomesList.get(this.index);
                Location homeLocation = this.usermapStorageUtil.getHomeLocationByHomeName(user, homeName);
                ItemStack homeItem = new ItemStack(EpicHomes.getPlugin().getConfigManager().getHomeListGUIItemMaterial(), 1);
                ItemMeta itemMeta = homeItem.getItemMeta();
                itemMeta.setDisplayName(ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getHomeListGUIItemName()).replace(HOME_NAME_PLACEHOLDER, homeName));
                List<String> loreConfigList = EpicHomes.getPlugin().getConfigManager().getHomeListGUIItemLore();
                ArrayList<String> homeLore = new ArrayList<String>();
                if (homeLocation.getWorld() == null) {
                    MessageUtils.sendDebugConsole("warning", "&cPlayer: " + user.getLastKnownName());
                    MessageUtils.sendDebugConsole("warning", "&cHome location world is null for home: " + homeName);
                    continue;
                }
                for (String string : loreConfigList) {
                    homeLore.add(ColorUtils.translateColorCodes(string).replace(HOME_LOCATION_PLACEHOLDER_WORLD, homeLocation.getWorld().getName()).replace(HOME_LOCATION_PLACEHOLDER_X, String.valueOf(Math.round(homeLocation.getX()))).replace(HOME_LOCATION_PLACEHOLDER_Y, String.valueOf(Math.round(homeLocation.getY()))).replace(HOME_LOCATION_PLACEHOLDER_Z, String.valueOf(Math.round(homeLocation.getZ()))));
                }
                itemMeta.setLore(homeLore);
                itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)EpicHomes.getPlugin(), "homeName"), PersistentDataType.STRING, (Object)homeName);
                homeItem.setItemMeta(itemMeta);
                this.inventory.addItem(new ItemStack[]{homeItem});
            }
        }
    }

    private static void fireHomePreTeleportEvent(Player player, User user, String homeName, Location homeLocation, Location oldLocation) {
        AsyncHomePreTeleportEvent asyncHomePreTeleportEvent = new AsyncHomePreTeleportEvent(player, user, homeName, homeLocation, oldLocation);
        Bukkit.getPluginManager().callEvent((Event)asyncHomePreTeleportEvent);
    }
}

