/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.menusystem.paginatedmenus;

import java.util.ArrayList;
import java.util.List;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.menusystem.PaginatedMenu;
import me.loving11ish.epichomes.menusystem.PlayerMenuUtility;
import me.loving11ish.epichomes.menusystem.menus.DeleteSingleGUI;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.ColorUtils;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DeleteHomesListGUI
extends PaginatedMenu {
    private static final String HOME_NAME_PLACEHOLDER = "%HOME%";
    private static final String HOME_LOCATION_PLACEHOLDER_WORLD = "%LOCATION-WORLD%";
    private static final String HOME_LOCATION_PLACEHOLDER_X = "%LOCATION-X%";
    private static final String HOME_LOCATION_PLACEHOLDER_Y = "%LOCATION-Y%";
    private static final String HOME_LOCATION_PLACEHOLDER_Z = "%LOCATION-Z%";
    private final UsermapStorageUtil usermapStorageUtil = EpicHomes.getPlugin().getUsermapStorageUtil();

    public DeleteHomesListGUI(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getHomeListDeleteGUITitle());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        User user = this.usermapStorageUtil.getUserByOnlinePlayer(player);
        List<String> userHomesList = this.usermapStorageUtil.getHomeNamesListByUser(user);
        this.playerMenuUtility.setUser(user);
        if (event.isLeftClick()) {
            if (event.getCurrentItem().getType().equals((Object)EpicHomes.getPlugin().getConfigManager().getHomeListDeleteGUIItemMaterial())) {
                String homeName = (String)event.getCurrentItem().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)EpicHomes.getPlugin(), "homeName"), PersistentDataType.STRING);
                if (homeName != null) {
                    this.playerMenuUtility.setHomeName(homeName);
                    this.playerMenuUtility.setHomeLocation(this.usermapStorageUtil.getHomeLocationByHomeName(user, homeName));
                    new DeleteSingleGUI(this.playerMenuUtility).open();
                }
            } else if (event.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
                player.closeInventory();
            } else if (event.getCurrentItem().getType().equals((Object)Material.STONE_BUTTON)) {
                if (event.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getMenuPreviousPageItemName()))) {
                    if (this.page == 0) {
                        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getGuiFirstPage());
                    } else {
                        --this.page;
                        super.open();
                    }
                } else if (event.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getMenuNextPageItemName()))) {
                    if (this.index + 1 < userHomesList.size()) {
                        ++this.page;
                        super.open();
                    } else {
                        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getGuiLastPage());
                    }
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.addMenuControls();
        User user = this.usermapStorageUtil.getUserByOnlinePlayer(this.playerMenuUtility.getOwner());
        List<String> userHomesList = this.usermapStorageUtil.getHomeNamesListByUser(user);
        if (userHomesList != null && !userHomesList.isEmpty()) {
            for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index >= userHomesList.size()) break;
                if (userHomesList.get(this.index) == null) continue;
                String homeName = userHomesList.get(this.index);
                Location homeLocation = this.usermapStorageUtil.getHomeLocationByHomeName(user, homeName);
                ItemStack homeItem = new ItemStack(EpicHomes.getPlugin().getConfigManager().getHomeListDeleteGUIItemMaterial(), 1);
                ItemMeta itemMeta = homeItem.getItemMeta();
                itemMeta.setDisplayName(ColorUtils.translateColorCodes(EpicHomes.getPlugin().getConfigManager().getHomeListDeleteGUIItemName()).replace(HOME_NAME_PLACEHOLDER, homeName));
                List<String> loreConfigList = EpicHomes.getPlugin().getConfigManager().getHomeListDeleteGUIItemLore();
                ArrayList<String> homeLore = new ArrayList<String>();
                for (String string : loreConfigList) {
                    homeLore.add(ColorUtils.translateColorCodes(string).replace(HOME_LOCATION_PLACEHOLDER_WORLD, homeLocation.getWorld().getName()).replace(HOME_LOCATION_PLACEHOLDER_X, String.valueOf(Math.round(homeLocation.getX()))).replace(HOME_LOCATION_PLACEHOLDER_Y, String.valueOf(Math.round(homeLocation.getY()))).replace(HOME_LOCATION_PLACEHOLDER_Z, String.valueOf(Math.round(homeLocation.getZ()))));
                }
                itemMeta.setLore(homeLore);
                itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)EpicHomes.getPlugin(), "homeName"), PersistentDataType.STRING, (Object)homeName);
                homeItem.setItemMeta(itemMeta);
                this.inventory.addItem(new ItemStack[]{homeItem});
            }
        }
    }
}

