/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.managers.filemanagers;

import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final FileConfiguration config;
    private boolean debugMode = false;
    private boolean updateNotifications = false;
    private boolean useTieredHomeLimit = false;
    private boolean useDelayBeforeHomeTP = false;
    private boolean useMovementTPCancel = false;
    private boolean useCommandCooldown = false;
    private boolean useDataImporter = false;
    private boolean showAutoSaveConsoleMessage = false;
    private boolean useGUI = false;
    private int defaultHomeLimit = 3;
    private int teleportDelayTime = 5;
    private int commandCooldownTime = 60;
    private String dataImportPlugin;
    private String homeListGUITitle;
    private String homeListGUIItemName;
    private String homeListDeleteGUITitle;
    private String homeListDeleteGUIItemName;
    private String homeSingleDeleteGUITitle;
    private String homeSingleDeleteGUIHomeItemName;
    private String homeSingleDeleteGUIConfirmItemName;
    private String homeSingleDeleteGUICancelItemName;
    private String menuPreviousPageItemName;
    private String menuNextPageItemName;
    private String menuCloseItemName;
    private List<String> bannedHomeNames;
    private List<String> homeListGUIItemLore;
    private List<String> homeListDeleteGUIItemLore;
    private List<String> homeSingleDeleteGUIHomeItemLore;
    private List<String> homeSingleDeleteGUIConfirmItemLore;
    private List<String> homeSingleDeleteGUICancelItemLore;
    private List<Map<?, ?>> tieredHomesMaxAmountGroups;
    private Material homeListGUIItemMaterial;
    private Material homeListDeleteGUIItemMaterial;
    private Material homeSingleDeleteGUIHomeItemMaterial;
    private Material homeSingleDeleteGUIConfirmItemMaterial;
    private Material homeSingleDeleteGUICancelItemMaterial;

    public ConfigManager(FileConfiguration config) {
        this.config = config;
    }

    public void loadConfigValues() {
        this.debugMode = this.config.getBoolean("general.developer-debug-mode.enabled", false);
        this.updateNotifications = this.config.getBoolean("plugin-update-notifications.enabled", true);
        this.useTieredHomeLimit = this.config.getBoolean("homes.permission-based-homes-max-amount.enabled", false);
        this.useDelayBeforeHomeTP = this.config.getBoolean("homes.teleportation.delay-before-teleport.enabled", true);
        this.useMovementTPCancel = this.config.getBoolean("homes.teleportation.delay-before-teleport.cancel-teleport-on-move", true);
        this.useCommandCooldown = this.config.getBoolean("general.command-cool-down.enabled", false);
        this.useDataImporter = this.config.getBoolean("general.home-data-importer.enabled", false);
        this.showAutoSaveConsoleMessage = this.config.getBoolean("general.show-auto-save-task-message.enabled", true);
        this.useGUI = this.config.getBoolean("gui-system.use-global-gui.enabled", true);
        this.defaultHomeLimit = this.config.getInt("homes.default-max-homes", 3);
        this.teleportDelayTime = this.config.getInt("homes.teleportation.delay-before-teleport.time", 5);
        this.commandCooldownTime = this.config.getInt("general.command-cool-down.cool-down-time", 60);
        this.dataImportPlugin = this.config.getString("general.home-data-importer.import-from", "EssentialsX");
        this.homeListGUITitle = this.config.getString("gui-system.home-list-gui.title", "&d&nYour Homes:");
        this.homeListGUIItemName = this.config.getString("gui-system.home-list-gui.icons.display-name", "&6%HOME%");
        this.homeListDeleteGUITitle = this.config.getString("gui-system.delete-list-gui.title", "&d&nSelect Home To Delete");
        this.homeListDeleteGUIItemName = this.config.getString("gui-system.delete-list-gui.icons.display-name", "&6%HOME%");
        this.homeSingleDeleteGUITitle = this.config.getString("gui-system.delete-single-home-gui.title", "&d&nDelete %HOME%");
        this.homeSingleDeleteGUIHomeItemName = this.config.getString("gui-system.delete-single-home-gui.icons.home-info.display-name", "&6%HOME%");
        this.homeSingleDeleteGUIConfirmItemName = this.config.getString("gui-system.delete-single-home-gui.icons.confirm-delete.display-name", "&cConfirm");
        this.homeSingleDeleteGUICancelItemName = this.config.getString("gui-system.delete-single-home-gui.icons.cancel-delete.display-name", "&aCancel");
        this.menuPreviousPageItemName = this.config.getString("gui-system.menu-controls.previous-page-icon-name", "&2Previous Page");
        this.menuNextPageItemName = this.config.getString("gui-system.menu-controls.next-page-icon-name", "&2Next Page");
        this.menuCloseItemName = this.config.getString("gui-system.menu-controls.close-go-back-icon-name", "&4Close/Go Back");
        this.bannedHomeNames = this.config.getStringList("homes.disallowed-home-names");
        this.homeListGUIItemLore = this.config.getStringList("gui-system.home-list-gui.icons.lore");
        this.homeListDeleteGUIItemLore = this.config.getStringList("gui-system.delete-list-gui.icons.lore");
        this.homeSingleDeleteGUIHomeItemLore = this.config.getStringList("gui-system.delete-single-home-gui.icons.home-info.lore");
        this.homeSingleDeleteGUIConfirmItemLore = this.config.getStringList("gui-system.delete-single-home-gui.icons.confirm-delete.lore");
        this.homeSingleDeleteGUICancelItemLore = this.config.getStringList("gui-system.delete-single-home-gui.icons.cancel-delete.lore");
        this.tieredHomesMaxAmountGroups = this.config.getMapList("homes.permission-based-homes-max-amount.permission-group-list");
        this.homeListGUIItemMaterial = Material.getMaterial((String)this.config.getString("gui-system.home-list-gui.icons.home-material", "RED_BED"));
        this.homeListDeleteGUIItemMaterial = Material.getMaterial((String)this.config.getString("gui-system.delete-list-gui.icons.home-material", "RED_BED"));
        this.homeSingleDeleteGUIHomeItemMaterial = Material.getMaterial((String)this.config.getString("gui-system.delete-single-home-gui.icons.home-info.home-material", "RED_BED"));
        this.homeSingleDeleteGUIConfirmItemMaterial = Material.getMaterial((String)this.config.getString("gui-system.delete-single-home-gui.icons.confirm-delete.material", "TNT"));
        this.homeSingleDeleteGUICancelItemMaterial = Material.getMaterial((String)this.config.getString("gui-system.delete-single-home-gui.icons.cancel-delete.material", "BARRIER"));
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isUpdateNotifications() {
        return this.updateNotifications;
    }

    public boolean isUseTieredHomeLimit() {
        return this.useTieredHomeLimit;
    }

    public boolean isUseDelayBeforeHomeTP() {
        return this.useDelayBeforeHomeTP;
    }

    public boolean isUseMovementTPCancel() {
        return this.useMovementTPCancel;
    }

    public boolean isUseCommandCooldown() {
        return this.useCommandCooldown;
    }

    public boolean isUseDataImporter() {
        return this.useDataImporter;
    }

    public boolean isShowAutoSaveConsoleMessage() {
        return this.showAutoSaveConsoleMessage;
    }

    public boolean isUseGUI() {
        return this.useGUI;
    }

    public int getDefaultHomeLimit() {
        return this.defaultHomeLimit;
    }

    public int getTeleportDelayTime() {
        return this.teleportDelayTime;
    }

    public int getCommandCooldownTime() {
        return this.commandCooldownTime;
    }

    public String getDataImportPlugin() {
        return this.dataImportPlugin;
    }

    public String getHomeListGUITitle() {
        return this.homeListGUITitle;
    }

    public String getHomeListGUIItemName() {
        return this.homeListGUIItemName;
    }

    public String getHomeListDeleteGUITitle() {
        return this.homeListDeleteGUITitle;
    }

    public String getHomeListDeleteGUIItemName() {
        return this.homeListDeleteGUIItemName;
    }

    public String getHomeSingleDeleteGUITitle() {
        return this.homeSingleDeleteGUITitle;
    }

    public String getHomeSingleDeleteGUIHomeItemName() {
        return this.homeSingleDeleteGUIHomeItemName;
    }

    public String getHomeSingleDeleteGUIConfirmItemName() {
        return this.homeSingleDeleteGUIConfirmItemName;
    }

    public String getHomeSingleDeleteGUICancelItemName() {
        return this.homeSingleDeleteGUICancelItemName;
    }

    public String getMenuPreviousPageItemName() {
        return this.menuPreviousPageItemName;
    }

    public String getMenuNextPageItemName() {
        return this.menuNextPageItemName;
    }

    public String getMenuCloseItemName() {
        return this.menuCloseItemName;
    }

    public List<String> getHomeListGUIItemLore() {
        return this.homeListGUIItemLore;
    }

    public List<String> getBannedHomeNames() {
        return this.bannedHomeNames;
    }

    public List<String> getHomeListDeleteGUIItemLore() {
        return this.homeListDeleteGUIItemLore;
    }

    public List<String> getHomeSingleDeleteGUIHomeItemLore() {
        return this.homeSingleDeleteGUIHomeItemLore;
    }

    public List<String> getHomeSingleDeleteGUIConfirmItemLore() {
        return this.homeSingleDeleteGUIConfirmItemLore;
    }

    public List<String> getHomeSingleDeleteGUICancelItemLore() {
        return this.homeSingleDeleteGUICancelItemLore;
    }

    public List<Map<?, ?>> getTieredHomesMaxAmountGroups() {
        return this.tieredHomesMaxAmountGroups;
    }

    public Material getHomeListGUIItemMaterial() {
        return this.homeListGUIItemMaterial;
    }

    public Material getHomeListDeleteGUIItemMaterial() {
        return this.homeListDeleteGUIItemMaterial;
    }

    public Material getHomeSingleDeleteGUIHomeItemMaterial() {
        return this.homeSingleDeleteGUIHomeItemMaterial;
    }

    public Material getHomeSingleDeleteGUIConfirmItemMaterial() {
        return this.homeSingleDeleteGUIConfirmItemMaterial;
    }

    public Material getHomeSingleDeleteGUICancelItemMaterial() {
        return this.homeSingleDeleteGUICancelItemMaterial;
    }
}

