/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.libs.lightlibs.simplehttpwrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import me.loving11ish.epichomes.libs.lightlibs.simplehttpwrapper.SimpleHttpResponse;
import me.loving11ish.epichomes.libs.lightlibs.simplehttpwrapper.SupportedHttpMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleHttpWrapper {
    public static SimpleHttpResponse get(@NotNull String urlStr, @Nullable String[] headers) throws IOException {
        return SimpleHttpWrapper.performRequest(SupportedHttpMethod.GET, urlStr, headers, null);
    }

    public static SimpleHttpResponse post(@NotNull String urlStr, @Nullable String[] headers, @Nullable String postData) throws IOException {
        return SimpleHttpWrapper.performRequest(SupportedHttpMethod.POST, urlStr, headers, postData);
    }

    public static SimpleHttpResponse performRequest(@NotNull SupportedHttpMethod method, String urlStr, @Nullable String[] headers, @Nullable String postData) throws IOException {
        return SimpleHttpWrapper.httpRequest(method.getRawMethodName(), urlStr, headers, postData);
    }

    @Deprecated
    public static SimpleHttpResponse performRequestUnsupported(@NotNull String method, String urlStr, @Nullable String[] headers, @Nullable String postData) throws IOException {
        return SimpleHttpWrapper.httpRequest(method, urlStr, headers, postData);
    }

    @NotNull
    private static SimpleHttpResponse httpRequest(@NotNull String method, String urlStr, @Nullable String[] headers, @Nullable String postData) throws IOException {
        String line;
        int responseCode;
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        if (headers != null) {
            for (String headerEntry : headers) {
                String[] parts;
                if (headerEntry == null || (parts = headerEntry.split(":")).length != 2) continue;
                String key = parts[0];
                String value = parts[1];
                connection.setRequestProperty(key, value);
            }
        }
        if (method.equals("POST") && postData != null) {
            try (OutputStream os = connection.getOutputStream();){
                byte[] postDataBytes = postData.getBytes(StandardCharsets.UTF_8);
                os.write(postDataBytes, 0, postDataBytes.length);
            }
        }
        InputStream inputStream = (responseCode = connection.getResponseCode()) >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder strb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            strb.append(line);
        }
        reader.close();
        connection.disconnect();
        return new SimpleHttpResponse(responseCode, strb.toString());
    }
}

