/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.importers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class StormerHomesDataReader {
    public boolean homesImportSuccessful = false;
    private final UsermapStorageUtil usermapStorageUtil = EpicHomes.getPlugin().getUsermapStorageUtil();
    private YamlConfiguration fileReader;
    private String world = null;
    private String homeName = null;
    private String playerName = null;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private float yaw = 0.0f;
    private float pitch = 0.0f;

    public StormerHomesDataReader() {
        CompletableFuture.runAsync(() -> {
            try {
                this.fileReader = new YamlConfiguration();
                File stormerData = Bukkit.getServer().getPluginManager().getPlugin("StormerHomes").getDataFolder();
                File stormerConfig = new File(stormerData, "config.yml");
                this.fileReader.load(stormerConfig);
                MessageUtils.sendDebugConsole("&aFound StormerHomes config.yml and loaded successfully.");
                if (this.loadHomes()) {
                    this.homesImportSuccessful = true;
                }
            }
            catch (IOException | NullPointerException | InvalidConfigurationException e) {
                MessageUtils.sendConsole("error", "&4&lCannot find StormerHomes data file!");
            }
        });
    }

    private boolean loadHomes() {
        try {
            if (this.fileReader.getConfigurationSection("homes2") != null) {
                MessageUtils.sendDebugConsole("&aFound homes2 section in StormerHomes config.yml");
                Set keys = this.fileReader.getConfigurationSection("homes2").getKeys(false);
                for (String key : keys) {
                    User user;
                    HashMap<String, Location> homes = new HashMap<String, Location>();
                    Set homeKeys = this.fileReader.getConfigurationSection("homes2." + key).getKeys(false);
                    Iterator iterator = homeKeys.iterator();
                    while (iterator.hasNext()) {
                        String home;
                        this.homeName = home = (String)iterator.next();
                        MessageUtils.sendDebugConsole("&aFound home name entry of: " + home + " for UUID: " + key);
                        this.world = this.fileReader.getString("homes2." + key + "." + home + ".world");
                        MessageUtils.sendDebugConsole("&aFound world entry for home: " + home + ". World entry: " + this.world);
                        this.playerName = this.fileReader.getString("homes2." + key + "." + home + ".playername");
                        MessageUtils.sendDebugConsole("&aFound playername entry for home: " + home + ". PlayerName entry: " + this.playerName);
                        this.x = this.fileReader.getDouble("homes2." + key + "." + home + ".x");
                        MessageUtils.sendDebugConsole("&aFound x entry for home: " + home + ". X entry: " + this.x);
                        this.y = this.fileReader.getDouble("homes2." + key + "." + home + ".y");
                        MessageUtils.sendDebugConsole("&aFound y entry for home: " + home + ". Y entry: " + this.y);
                        this.z = this.fileReader.getDouble("homes2." + key + "." + home + ".z");
                        MessageUtils.sendDebugConsole("&aFound z entry for home: " + home + ". Z entry: " + this.z);
                        this.yaw = (float)this.fileReader.getDouble("homes2." + key + "." + home + ".yaw");
                        MessageUtils.sendDebugConsole("&aFound yaw entry for home: " + home + ". Yaw entry: " + this.yaw);
                        this.pitch = (float)this.fileReader.getDouble("homes2." + key + "." + home + ".pitch");
                        MessageUtils.sendDebugConsole("&aFound pitch entry for home: " + home + ". Pitch entry: " + this.pitch);
                        EpicHomes.getFoliaLib().getScheduler().runNextTick(task -> {
                            World homeWorld = Bukkit.getWorld((String)this.world);
                            if (homeWorld == null) {
                                MessageUtils.sendDebugConsole("&4&lCould not find world: " + this.world + " for home: " + this.homeName + " for player: " + this.playerName);
                                MessageUtils.sendDebugConsole("&4&lSkipping home: " + this.homeName + " for player: " + this.playerName);
                            } else {
                                Location location = new Location(homeWorld, this.x, this.y, this.z, this.yaw, this.pitch);
                                homes.put(this.homeName, location);
                                MessageUtils.sendDebugConsole("&aHome: " + home + " has been successfully created for player: " + this.playerName);
                            }
                        });
                    }
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(key));
                    if (this.usermapStorageUtil.isUserExisting(offlinePlayer)) {
                        user = this.usermapStorageUtil.getUserByOfflinePlayer(offlinePlayer);
                        HashMap<String, Location> usersCurrentHomes = user.getHomesList();
                        for (Map.Entry homesList : homes.entrySet()) {
                            if (!usersCurrentHomes.containsKey(homesList.getKey())) {
                                usersCurrentHomes.put((String)homesList.getKey(), (Location)homesList.getValue());
                                MessageUtils.sendDebugConsole("&aPlayer " + user.getLastKnownName() + " already exists in the usermap");
                                MessageUtils.sendDebugConsole("&aSuccessfully added new home: " + this.homeName + " to player.");
                                continue;
                            }
                            MessageUtils.sendDebugConsole("&aPlayer " + user.getLastKnownName() + " already exists in the usermap");
                            MessageUtils.sendDebugConsole("&aThe current home iteration already exists! Skipping...");
                        }
                        user.setHomesList(usersCurrentHomes);
                        this.usermapStorageUtil.getUsermapStorage().replace(UUID.fromString(key), user);
                        continue;
                    }
                    user = new User(key, this.playerName);
                    user.setHomesList(homes);
                    this.usermapStorageUtil.getUsermapStorage().put(UUID.fromString(key), user);
                    MessageUtils.sendDebugConsole("&aPlayer " + user.getLastKnownName() + " has never joined this server before!");
                    MessageUtils.sendDebugConsole("&aThey have been added to the usermap and had their homes stored!");
                }
                return true;
            }
        }
        catch (NullPointerException e) {
            MessageUtils.sendConsole("error", "&4&lCould not load homes from StormerHomes plugin!");
            MessageUtils.sendConsole("error", "&4&lSee below for error message!");
            e.printStackTrace();
        }
        return false;
    }
}

