/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.importers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class EssentialsXHomesDataReader {
    public boolean homesImportSuccessful = false;
    private final UsermapStorageUtil usermapStorageUtil = EpicHomes.getPlugin().getUsermapStorageUtil();
    private YamlConfiguration fileReader;
    private String playerName = null;
    private String uuid = null;

    public EssentialsXHomesDataReader() {
        CompletableFuture.runAsync(() -> {
            try {
                this.fileReader = new YamlConfiguration();
                Plugin plugin = Bukkit.getPluginManager().getPlugin("Essentials");
                File[] files = new File(String.valueOf(plugin.getDataFolder().getParentFile()) + File.separator + "Essentials" + File.separator + "userdata").listFiles();
                if (files != null) {
                    for (File file : files) {
                        this.fileReader.load(file);
                        this.playerName = this.fileReader.getString("last-account-name");
                        this.uuid = file.getName().replace(".yml", "");
                        MessageUtils.sendDebugConsole("User UUID: " + this.uuid);
                        this.getHomes();
                    }
                }
                this.homesImportSuccessful = true;
            }
            catch (IOException | NullPointerException | InvalidConfigurationException e) {
                MessageUtils.sendConsole("error", "Cannot find EssentialsX player data file!");
            }
        });
    }

    private void getHomes() {
        try {
            if (this.fileReader.getConfigurationSection("homes") != null) {
                Set names = this.fileReader.getConfigurationSection("homes").getKeys(false);
                for (String name : names) {
                    MessageUtils.sendDebugConsole("&aFound home name entry of: " + name);
                    Set data = this.fileReader.getConfigurationSection("homes." + name).getKeys(false);
                    String world = null;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    float yaw = 0.0f;
                    float pitch = 0.0f;
                    for (String info : data) {
                        if (info == null) {
                            MessageUtils.sendDebugConsole("&cNo data found for home: " + name + "! Skipping...");
                            continue;
                        }
                        switch (info) {
                            case "world": {
                                world = this.fileReader.get("homes." + name + "." + info).toString();
                                MessageUtils.sendDebugConsole("&aWorld UUID: " + this.fileReader.getString("homes." + name + "." + info));
                                MessageUtils.sendDebugConsole("&aFound world entry for home: " + name + " world entry: " + world);
                                break;
                            }
                            case "x": {
                                x = Double.parseDouble(this.fileReader.get("homes." + name + "." + info).toString());
                                MessageUtils.sendDebugConsole("&aFound x entry for home: " + name + " x entry: " + x);
                                break;
                            }
                            case "y": {
                                y = Double.parseDouble(this.fileReader.get("homes." + name + "." + info).toString());
                                MessageUtils.sendDebugConsole("&aFound y entry for home: " + name + " y entry: " + y);
                                break;
                            }
                            case "z": {
                                z = Double.parseDouble(this.fileReader.get("homes." + name + "." + info).toString());
                                MessageUtils.sendDebugConsole("&aFound z entry for home: " + name + " z entry: " + z);
                                break;
                            }
                            case "yaw": {
                                yaw = Float.parseFloat(this.fileReader.get("homes." + name + "." + info).toString());
                                MessageUtils.sendDebugConsole("&aFound yaw entry for home: " + name + " yaw entry: " + yaw);
                                break;
                            }
                            case "pitch": {
                                pitch = Float.parseFloat(this.fileReader.get("homes." + name + "." + info).toString());
                                MessageUtils.sendDebugConsole("&aFound pitch entry for home: " + name + " pitch entry: " + pitch);
                            }
                        }
                    }
                    String finalWorld = world;
                    double finalX = x;
                    double finalY = y;
                    double finalZ = z;
                    float finalYaw = yaw;
                    float finalPitch = pitch;
                    String finalUuid = this.uuid;
                    String finalPlayerName = this.playerName;
                    EpicHomes.getFoliaLib().getScheduler().runNextTick(task -> {
                        UUID userUUID = UUID.fromString(finalUuid);
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)userUUID);
                        if (this.usermapStorageUtil.isUserExisting(offlinePlayer)) {
                            User user = this.usermapStorageUtil.getUserByOfflinePlayer(offlinePlayer);
                            List<String> userHomeNames = this.usermapStorageUtil.getHomeNamesListByUser(user);
                            if (!userHomeNames.contains(name)) {
                                if (finalWorld == null || Bukkit.getWorld((UUID)UUID.fromString(finalWorld)) == null) {
                                    MessageUtils.sendDebugConsole("&cWorld UUID: " + finalWorld);
                                    MessageUtils.sendDebugConsole("&cWorld does not exist for " + name + "! Skipping...");
                                } else {
                                    Location location = new Location(Bukkit.getWorld((UUID)UUID.fromString(finalWorld)), finalX, finalY, finalZ, finalYaw, finalPitch);
                                    this.usermapStorageUtil.addHomeToUser(user, name, location);
                                    MessageUtils.sendDebugConsole("&aPlayer " + user.getLastKnownName() + " already exists in the usermap");
                                    MessageUtils.sendDebugConsole("&aSuccessfully added new home &e" + name + " &ato player: &d" + user.getLastKnownName());
                                }
                            } else {
                                MessageUtils.sendDebugConsole("&aPlayer " + user.getLastKnownName() + " already exists in the usermap");
                                MessageUtils.sendDebugConsole("&aThe home " + name + " already exists! Skipping...");
                            }
                        } else {
                            User user = new User(finalUuid, finalPlayerName);
                            this.usermapStorageUtil.getUsermapStorage().put(UUID.fromString(finalUuid), user);
                            if (finalWorld == null || Bukkit.getWorld((UUID)UUID.fromString(finalWorld)) == null) {
                                MessageUtils.sendDebugConsole("&cWorld UUID: " + finalWorld);
                                MessageUtils.sendDebugConsole("&cWorld does not exist for " + name + "! Skipping...");
                            } else {
                                Location location = new Location(Bukkit.getWorld((UUID)UUID.fromString(finalWorld)), finalX, finalY, finalZ, finalYaw, finalPitch);
                                this.usermapStorageUtil.addHomeToUser(user, name, location);
                                MessageUtils.sendDebugConsole("&aPlayer &d" + user.getLastKnownName() + " &ahas never joined this server before!");
                                MessageUtils.sendDebugConsole("&aThey have been added to the usermap.");
                                MessageUtils.sendDebugConsole("&aSuccessfully added new home &e" + name + " &ato player: &d" + user.getLastKnownName());
                            }
                        }
                    });
                }
            }
        }
        catch (NullPointerException e) {
            MessageUtils.sendConsole("error", "Could not load homes from EssentialsX plugin!");
            MessageUtils.sendConsole("error", "See below for error message!");
            e.printStackTrace();
        }
    }
}

