/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.utils.MessageUtils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class UsermapFileManager {
    private final EpicHomes plugin;
    private FileConfiguration dataConfig = null;
    private File configFile = null;

    public UsermapFileManager(EpicHomes plugin) {
        this.plugin = plugin;
        this.saveDefaultUsermapConfig();
    }

    public void reloadUsermapConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "usermap.yml");
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defaultStream = this.plugin.getResource("usermap.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.dataConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getUsermapConfig() {
        if (this.dataConfig == null) {
            this.reloadUsermapConfig();
        }
        return this.dataConfig;
    }

    public void saveUsermapConfig() {
        if (this.dataConfig == null || this.configFile == null) {
            return;
        }
        try {
            this.getUsermapConfig().save(this.configFile);
        }
        catch (IOException e) {
            MessageUtils.sendConsole("error", "&4Could not save usermap.yml");
            MessageUtils.sendConsole("error", "&4Check the below message for the reasons!");
            e.printStackTrace();
        }
    }

    public void saveDefaultUsermapConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "usermap.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("usermap.yml", false);
        }
    }
}

