/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.externalhooks;

import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.ColorUtils;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    private final UsermapStorageUtil usermapStorageUtil = EpicHomes.getPlugin().getUsermapStorageUtil();

    @NotNull
    public String getIdentifier() {
        return "epicHomes";
    }

    @NotNull
    public String getAuthor() {
        return EpicHomes.getPlugin().getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return EpicHomes.getPlugin().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, String params) {
        User user = this.usermapStorageUtil.getUserByOfflinePlayer(offlinePlayer);
        List<String> userHomesList = this.usermapStorageUtil.getHomeNamesListByUser(user);
        if (params.equalsIgnoreCase("pluginPrefix")) {
            return ColorUtils.translateColorCodes(MessageUtils.prefix);
        }
        if (params.equalsIgnoreCase("pluginVersion")) {
            return EpicHomes.getPlugin().getDescription().getVersion();
        }
        if (params.equalsIgnoreCase("pluginAuthor")) {
            return EpicHomes.getPlugin().getDescription().getAuthors().toString();
        }
        if (params.equalsIgnoreCase("baseServerVersion")) {
            return String.valueOf(EpicHomes.getPlugin().getVersionCheckerUtils().getVersion());
        }
        if (params.equalsIgnoreCase("serverPackage")) {
            return EpicHomes.getPlugin().getVersionCheckerUtils().getServerPackage();
        }
        if (params.equalsIgnoreCase("pluginEnabled")) {
            return String.valueOf(EpicHomes.getPlugin().isPluginEnabled());
        }
        if (params.equalsIgnoreCase("totalPlayerJoined")) {
            return String.valueOf(this.usermapStorageUtil.getUsermapStorage().size());
        }
        if (params.equalsIgnoreCase("userLastKnownName")) {
            return user.getLastKnownName();
        }
        if (params.equalsIgnoreCase("userUUID")) {
            return user.getUserUUID();
        }
        if (params.equalsIgnoreCase("userHomeListSize")) {
            if (userHomesList != null && !userHomesList.isEmpty()) {
                return String.valueOf(userHomesList.size());
            }
            return "";
        }
        if (params.equalsIgnoreCase("userHomeList")) {
            if (userHomesList != null && !userHomesList.isEmpty()) {
                return String.join((CharSequence)", ", userHomesList);
            }
            return "";
        }
        return null;
    }
}

