/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.commands;

import java.util.ArrayList;
import java.util.List;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.commands.subcommands.DeleteSubCommand;
import me.loving11ish.epichomes.commands.subcommands.HomeAdminVisitSubCommand;
import me.loving11ish.epichomes.commands.subcommands.ListSubCommand;
import me.loving11ish.epichomes.commands.subcommands.ReloadSubCommand;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.ColorUtils;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HomeAdminCommand
implements CommandExecutor,
TabCompleter {
    private final UsermapStorageUtil usermapStorageUtil = EpicHomes.getPlugin().getUsermapStorageUtil();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length < 1) {
                MessageUtils.sendPlayerNoPrefix(player, this.sendUsageMessage());
                return true;
            }
            if (args[0].equalsIgnoreCase("delete") || args[0].equalsIgnoreCase("list") || args[0].equalsIgnoreCase("visit") || args[0].equalsIgnoreCase("reload")) {
                switch (args[0]) {
                    case "delete": {
                        if (args.length == 3) {
                            if (player.hasPermission("epichomes.command.deleteothers") || player.hasPermission("epichomes.command.*") || player.hasPermission("epichomes.admin") || player.hasPermission("epichomes.*") || player.isOp()) {
                                return new DeleteSubCommand().adminDeleteHomeSubCommand(sender, args);
                            }
                            MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getNoPermission());
                            return true;
                        }
                        MessageUtils.sendPlayerNoPrefix(player, this.sendUsageMessage());
                        return true;
                    }
                    case "visit": {
                        if (args.length == 3) {
                            if (player.hasPermission("epichomes.command.visitothers") || player.hasPermission("epichomes.command.*") || player.hasPermission("epichomes.admin") || player.hasPermission("epichomes.*") || player.isOp()) {
                                return new HomeAdminVisitSubCommand().homeAdminVisitSubCommand(sender, args);
                            }
                            MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getNoPermission());
                            return true;
                        }
                        MessageUtils.sendPlayerNoPrefix(player, this.sendUsageMessage());
                        return true;
                    }
                    case "list": {
                        if (args.length == 2) {
                            if (player.hasPermission("epichomes.command.listothers") || player.hasPermission("epichomes.command.*") || player.hasPermission("epichomes.admin") || player.hasPermission("epichomes.*") || player.isOp()) {
                                return new ListSubCommand().adminListSubCommand(sender, args);
                            }
                            MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getNoPermission());
                            return true;
                        }
                        MessageUtils.sendPlayerNoPrefix(player, this.sendUsageMessage());
                        return true;
                    }
                    case "reload": {
                        if (player.hasPermission("epichomes.command.reload") || player.hasPermission("epichomes.command.*") || player.hasPermission("epichomes.admin") || player.hasPermission("epichomes.*") || player.isOp()) {
                            return new ReloadSubCommand().reloadSubCommand(sender);
                        }
                        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getNoPermission());
                        return true;
                    }
                }
                MessageUtils.sendPlayerNoPrefix(player, this.sendUsageMessage());
            } else {
                MessageUtils.sendPlayerNoPrefix(player, this.sendUsageMessage());
            }
        } else if (sender instanceof ConsoleCommandSender) {
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    return new ReloadSubCommand().reloadSubCommand();
                }
                MessageUtils.sendConsole(this.sendUsageMessage());
                return true;
            }
            MessageUtils.sendConsole(this.sendUsageMessage());
            return true;
        }
        return true;
    }

    private String sendUsageMessage() {
        List<String> usage = EpicHomes.getPlugin().getMessagesManager().getHomeAdminCommandList();
        StringBuilder usageString = new StringBuilder();
        for (String line : usage) {
            usageString.append(ColorUtils.translateColorCodes(line));
        }
        return usageString.toString();
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        User user;
        OfflinePlayer offlinePlayer;
        ArrayList<String> arguments0 = new ArrayList<String>();
        arguments0.add("delete");
        arguments0.add("visit");
        arguments0.add("list");
        arguments0.add("reload");
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> result2 = new ArrayList<String>();
        if (args.length == 1) {
            for (String a : arguments0) {
                if (!a.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                result.add(a);
            }
            return result;
        }
        if (args.length == 2) {
            return null;
        }
        if (args.length == 3 && (offlinePlayer = this.usermapStorageUtil.getBukkitOfflinePlayerByLastKnownName(args[1])) != null && (user = this.usermapStorageUtil.getUserByOfflinePlayer(offlinePlayer)) != null) {
            List<String> userHomesList = this.usermapStorageUtil.getHomeNamesListByUser(user);
            for (String home : userHomesList) {
                if (!home.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                result2.add(home);
            }
            return result2;
        }
        return null;
    }
}

