/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.api.events.AsyncHomePreTeleportEvent;
import me.loving11ish.epichomes.libs.folialib.FoliaLib;
import me.loving11ish.epichomes.libs.folialib.wrapper.task.WrappedTask;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.TeleportationUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EpicHomesAPI {
    private static final FoliaLib foliaLib = EpicHomes.getFoliaLib();

    public static EpicHomes getPluginInstance() {
        return EpicHomes.getPlugin();
    }

    public static boolean isDebugModeEnabled() {
        return EpicHomes.getPlugin().getConfig().getBoolean("debug-mode");
    }

    public static boolean isPluginEnabled() {
        return EpicHomes.getPlugin().isEnabled();
    }

    public static String getServerPackage() {
        return EpicHomes.getPlugin().getVersionCheckerUtils().getServerPackage();
    }

    public static int getMajorServerVersion() {
        return EpicHomes.getPlugin().getVersionCheckerUtils().getVersion();
    }

    public static boolean isServerRunningOnline() {
        return EpicHomes.getPlugin().isOnlineMode();
    }

    public static String getPluginPrefix() {
        return EpicHomes.getPlugin().getMessagesManager().getPrefix();
    }

    public static FoliaLib getFoliaLibInstance() {
        return EpicHomes.getFoliaLib();
    }

    public static boolean isEpicHomesPluginUpdateAvailable() {
        return EpicHomes.getPlugin().isUpdateAvailable();
    }

    public static HashMap<UUID, User> getAllStoredUsers() {
        return EpicHomes.getPlugin().getUsermapStorageUtil().getUsermapStorage();
    }

    public static User getUserByBukkitPlayer(Player player) {
        return EpicHomes.getPlugin().getUsermapStorageUtil().getUserByOnlinePlayer(player);
    }

    public static User getUserByBukkitOfflinePlayer(OfflinePlayer offlinePlayer) {
        return EpicHomes.getPlugin().getUsermapStorageUtil().getUserByOfflinePlayer(offlinePlayer);
    }

    public static OfflinePlayer getBukkitOfflinePlayerFromLastKnownPlayerName(String lastKnownPlayerName) {
        return EpicHomes.getPlugin().getUsermapStorageUtil().getBukkitOfflinePlayerByLastKnownName(lastKnownPlayerName);
    }

    public static List<String> getHomeNamesListByUser(User user) {
        return EpicHomes.getPlugin().getUsermapStorageUtil().getHomeNamesListByUser(user);
    }

    public static Location getPlayerHomeLocationByHomeName(User user, String homeName) {
        return EpicHomes.getPlugin().getUsermapStorageUtil().getHomeLocationByHomeName(user, homeName);
    }

    public static WrappedTask getPlayerPendingTeleportTask(UUID uuid) {
        return EpicHomes.getPlugin().getTeleportationManager().getTeleportQueue().get(uuid);
    }

    public static void teleportPlayerToHomeLocation(Player player, Location homeLocation, String homeName) {
        User user = EpicHomes.getPlugin().getUsermapStorageUtil().getUserByOnlinePlayer(player);
        TeleportationUtils teleportationUtils = new TeleportationUtils();
        EpicHomesAPI.getFoliaLib().getScheduler().runAsync(task -> {
            EpicHomesAPI.fireHomePreTeleportEvent(player, user, homeName, homeLocation, player.getLocation());
            MessageUtils.sendDebugConsole("&aFired AsyncHomePreTeleportEvent");
        });
        teleportationUtils.teleportPlayerAsync(player, homeLocation, homeName);
    }

    public static void teleportPlayerToHomeLocationTimed(Player player, Location homeLocation, String homeName) {
        User user = EpicHomes.getPlugin().getUsermapStorageUtil().getUserByOnlinePlayer(player);
        TeleportationUtils teleportationUtils = new TeleportationUtils();
        EpicHomesAPI.getFoliaLib().getScheduler().runAsync(task -> {
            EpicHomesAPI.fireHomePreTeleportEvent(player, user, homeName, homeLocation, player.getLocation());
            MessageUtils.sendDebugConsole("&aFired AsyncHomePreTeleportEvent");
        });
        teleportationUtils.teleportPlayerAsyncTimed(player, homeLocation, homeName);
    }

    public static boolean addNewHomeToUser(User user, String homeName, Location homeLocation) {
        return EpicHomes.getPlugin().getUsermapStorageUtil().addHomeToUser(user, homeName, homeLocation);
    }

    public static boolean removeHomeFromUser(User user, String homeName) throws IOException {
        return EpicHomes.getPlugin().getUsermapStorageUtil().removeHomeFromUser(user, homeName);
    }

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    private static void fireHomePreTeleportEvent(Player player, User user, String homeName, Location homeLocation, Location oldLocation) {
        AsyncHomePreTeleportEvent asyncHomePreTeleportEvent = new AsyncHomePreTeleportEvent(player, user, homeName, homeLocation, oldLocation);
        Bukkit.getPluginManager().callEvent((Event)asyncHomePreTeleportEvent);
    }
}

