/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.loving11ish.epichomes.commands.DeleteHomeCommand;
import me.loving11ish.epichomes.commands.HomeAdminCommand;
import me.loving11ish.epichomes.commands.HomeCommand;
import me.loving11ish.epichomes.commands.HomeImportCommand;
import me.loving11ish.epichomes.commands.SetHomeCommand;
import me.loving11ish.epichomes.externalhooks.PlaceholderAPI;
import me.loving11ish.epichomes.externalhooks.PlaceholderAPIHook;
import me.loving11ish.epichomes.files.MessagesFileManager;
import me.loving11ish.epichomes.files.UsermapFileManager;
import me.loving11ish.epichomes.libs.adventure.adventure.platform.bukkit.BukkitAudiences;
import me.loving11ish.epichomes.libs.folialib.FoliaLib;
import me.loving11ish.epichomes.libs.folialib.wrapper.task.WrappedTask;
import me.loving11ish.epichomes.libs.paperlib.PaperLib;
import me.loving11ish.epichomes.listeners.MenuEvent;
import me.loving11ish.epichomes.listeners.PlayerCommandSendEvent;
import me.loving11ish.epichomes.listeners.PlayerConnectionEvent;
import me.loving11ish.epichomes.listeners.PlayerDisconnectionEvent;
import me.loving11ish.epichomes.listeners.PlayerMovementEvent;
import me.loving11ish.epichomes.listeners.PlayerPreConnectionEvent;
import me.loving11ish.epichomes.managers.TeleportationManager;
import me.loving11ish.epichomes.managers.filemanagers.ConfigManager;
import me.loving11ish.epichomes.managers.filemanagers.MessagesManager;
import me.loving11ish.epichomes.menusystem.PlayerMenuUtility;
import me.loving11ish.epichomes.updatesystem.JoinEvent;
import me.loving11ish.epichomes.updatesystem.UpdateChecker;
import me.loving11ish.epichomes.utils.AutoSaveTaskUtils;
import me.loving11ish.epichomes.utils.MessageUtils;
import me.loving11ish.epichomes.utils.UsermapStorageUtil;
import me.loving11ish.epichomes.utils.VersionCheckerUtils;
import me.loving11ish.epichomes.versionsystems.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public final class EpicHomes
extends JavaPlugin {
    private final PluginDescriptionFile pluginInfo = this.getDescription();
    private final String pluginVersion = this.pluginInfo.getVersion();
    private static EpicHomes plugin;
    private static FoliaLib foliaLib;
    private ServerVersion serverVersion;
    private BukkitAudiences bukkitAudiences;
    private VersionCheckerUtils versionCheckerUtils;
    private PlaceholderAPIHook placeholderAPIHook = null;
    private boolean isPluginEnabled = true;
    private boolean isOnlineMode = true;
    private boolean isGUIEnabled = true;
    private boolean isUpdateAvailable = false;
    private MessagesFileManager messagesFileManager;
    private UsermapFileManager usermapFileManager;
    private UsermapStorageUtil usermapStorageUtil;
    private ConfigManager configManager;
    private MessagesManager messagesManager;
    private TeleportationManager teleportationManager;
    private final List<String> pluginCommands = new ArrayList<String>();
    private static final HashMap<Player, PlayerMenuUtility> playerMenuUtilityMap;

    public void onLoad() {
        plugin = this;
        foliaLib = new FoliaLib((Plugin)this);
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        this.setConfigManager(new ConfigManager(this.getConfig()));
        this.getConfigManager().loadConfigValues();
        this.setMessagesFileManager(new MessagesFileManager(this));
        this.setMessagesManager(new MessagesManager(this.getMessagesFileManager().getMessagesConfig()));
        this.getMessagesManager().loadMessagesValues();
        MessageUtils.setDebug(this.getConfigManager().isDebugMode());
        this.setUsermapFileManager(new UsermapFileManager(this));
        this.versionCheckerUtils = new VersionCheckerUtils();
        this.versionCheckerUtils.getServerVersion();
        this.versionCheckerUtils.setVersion();
        if (this.versionCheckerUtils.getVersion() < 16 || this.versionCheckerUtils.getVersion() > 21 || !this.versionCheckerUtils.isVersionCheckedSuccessfully() && !this.serverVersion.serverVersionEqual(ServerVersion.Other)) {
            MessageUtils.sendConsole("&4-------------------------------------------");
            MessageUtils.sendConsole("&4Your server version is: &d" + Bukkit.getVersion());
            MessageUtils.sendConsole("&4This plugin is only supported on the Minecraft versions listed below:");
            MessageUtils.sendConsole("&41.16.x");
            MessageUtils.sendConsole("&41.17.x");
            MessageUtils.sendConsole("&41.18.x");
            MessageUtils.sendConsole("&41.19.x");
            MessageUtils.sendConsole("&41.20.x");
            MessageUtils.sendConsole("&41.21.x");
            MessageUtils.sendConsole("&4Is now disabling!");
            MessageUtils.sendConsole("&4-------------------------------------------");
            this.setPluginEnabled(false);
            return;
        }
        MessageUtils.sendConsole("&a-------------------------------------------");
        MessageUtils.sendConsole("&aA supported Minecraft version has been detected");
        MessageUtils.sendConsole("&aYour server version is: &d" + Bukkit.getVersion());
        MessageUtils.sendConsole("&6Continuing plugin startup");
        MessageUtils.sendConsole("&a-------------------------------------------");
        if (EpicHomes.getFoliaLib().isUnsupported()) {
            MessageUtils.sendConsole("&4-------------------------------------------");
            MessageUtils.sendConsole("&4Your server appears to running a version other than Spigot based!");
            MessageUtils.sendConsole("&4This plugin uses features that your server most likely doesn't have!");
            MessageUtils.sendConsole("&4Is now disabling!");
            MessageUtils.sendConsole("&4-------------------------------------------");
            this.setPluginEnabled(false);
            return;
        }
        if (EpicHomes.getFoliaLib().isSpigot()) {
            PaperLib.suggestPaper((Plugin)this);
        }
        this.setGUIEnabled(this.getConfigManager().isUseGUI());
        MessageUtils.sendDebugConsole("End of onLoad method");
    }

    public void onEnable() {
        if (!this.isPluginEnabled()) {
            MessageUtils.sendConsole("&4-------------------------------------------");
            MessageUtils.sendConsole("&4Plugin has been disabled during onLoad!");
            MessageUtils.sendConsole("&4See above for details!");
            MessageUtils.sendConsole("&4Disabling plugin!");
            MessageUtils.sendConsole("&4-------------------------------------------");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.bukkitAudiences = BukkitAudiences.create((Plugin)this);
            MessageUtils.sendConsole("-------------------------------------------");
            MessageUtils.sendConsole("&3Adventure Library hooked successfully!");
        }
        catch (Exception e) {
            MessageUtils.sendConsole("severe", "&4-------------------------------------------");
            MessageUtils.sendConsole("severe", "&4BukkitAudiences failed to be created!");
            MessageUtils.sendConsole("severe", "&4This plugin uses Adventure Library to function properly!");
            MessageUtils.sendConsole("severe", "&4Please send this error to the developer of ClansLite using below link!");
            MessageUtils.sendConsole("severe", "&4https://discord.gg/crapticraft");
            MessageUtils.sendConsole("severe", "&4Is now disabling!");
            MessageUtils.sendConsole("severe", "&4-------------------------------------------");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            this.setPluginEnabled(false);
            return;
        }
        this.setUsermapStorageUtil(new UsermapStorageUtil());
        if (this.getUsermapFileManager() != null && this.getUsermapFileManager().getUsermapConfig().contains("users.data")) {
            try {
                this.getUsermapStorageUtil().loadUsermap();
                MessageUtils.sendConsole("-------------------------------------------");
                MessageUtils.sendConsole("&3Successfully loaded usermap to memory.");
            }
            catch (IOException e) {
                MessageUtils.sendConsole("-------------------------------------------");
                MessageUtils.sendConsole("error", "&4Failed to load data from usermap.yml!");
                MessageUtils.sendConsole("error", "&4See below for errors!");
                MessageUtils.sendConsole("error", "&4Disabling Plugin!");
                e.printStackTrace();
                MessageUtils.sendConsole("-------------------------------------------");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        this.setTeleportationManager(new TeleportationManager());
        HomeCommand homeCommand = new HomeCommand();
        HomeAdminCommand homeAdminCommand = new HomeAdminCommand();
        this.getCommand("home").setExecutor((CommandExecutor)homeCommand);
        this.getCommand("home").setTabCompleter((TabCompleter)homeCommand);
        this.getCommand("homeadmin").setExecutor((CommandExecutor)homeAdminCommand);
        this.getCommand("homeadmin").setTabCompleter((TabCompleter)homeAdminCommand);
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand());
        this.getCommand("delhome").setExecutor((CommandExecutor)new DeleteHomeCommand());
        this.getCommand("importhomes").setExecutor((CommandExecutor)new HomeImportCommand());
        this.pluginCommands.add("/home");
        this.pluginCommands.add("/sethome");
        this.pluginCommands.add("/delhome");
        this.pluginCommands.add("/h");
        this.pluginCommands.add("/eh");
        this.pluginCommands.add("/delhome");
        this.pluginCommands.add("/homes");
        this.pluginCommands.add("/epichomes");
        this.pluginCommands.add("/homeadmin");
        this.pluginCommands.add("/ha");
        this.getServer().getPluginManager().registerEvents((Listener)new MenuEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMovementEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerPreConnectionEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDisconnectionEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandSendEvent(this.pluginCommands), (Plugin)this);
        HomeCommand.updateBannedNamesList();
        SetHomeCommand.updateBannedNamesList();
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") || PlaceholderAPI.isPlaceholderAPIEnabled()) {
            this.placeholderAPIHook = new PlaceholderAPIHook();
            this.placeholderAPIHook.register();
            MessageUtils.sendConsole("-------------------------------------------");
            MessageUtils.sendConsole("&3PlaceholderAPI found!");
            MessageUtils.sendConsole("&3External placeholders enabled!");
        } else {
            MessageUtils.sendConsole("-------------------------------------------");
            MessageUtils.sendConsole("&cPlaceholderAPI not found!");
            MessageUtils.sendConsole("&cExternal placeholders disabled!");
        }
        MessageUtils.sendConsole("&6Continuing plugin startup");
        MessageUtils.sendConsole("-------------------------------------------");
        MessageUtils.sendConsole("-------------------------------------------");
        MessageUtils.sendConsole("&3Plugin by: &b&lLoving11ish");
        MessageUtils.sendConsole("&3has been loaded successfully");
        MessageUtils.sendConsole("&3Plugin Version: &d&l" + this.pluginVersion);
        MessageUtils.sendDebugConsole("&aDeveloper debug mode enabled!");
        MessageUtils.sendDebugConsole("&aThis WILL fill the console");
        MessageUtils.sendDebugConsole("&awith additional EpicHomes information!");
        MessageUtils.sendDebugConsole("&aThis setting is not intended for ");
        MessageUtils.sendDebugConsole("&acontinous use!");
        MessageUtils.sendConsole("-------------------------------------------");
        new UpdateChecker(109590).getVersion(version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                MessageUtils.sendConsole(this.getMessagesManager().getUpdateCheckerNoUpdateOne());
                MessageUtils.sendConsole(this.getMessagesManager().getUpdateCheckerNoUpdateTwo());
                MessageUtils.sendConsole(this.getMessagesManager().getUpdateCheckerNoUpdateThree());
                this.setUpdateAvailable(false);
            } else {
                MessageUtils.sendConsole(this.getMessagesManager().getUpdateCheckerUpdateAvailableOne());
                MessageUtils.sendConsole(this.getMessagesManager().getUpdateCheckerUpdateAvailableTwo());
                MessageUtils.sendConsole(this.getMessagesManager().getUpdateCheckerUpdateAvailableThree());
                this.setUpdateAvailable(true);
            }
        });
        this.setPluginEnabled(true);
        EpicHomes.getFoliaLib().getScheduler().runLaterAsync(() -> {
            AutoSaveTaskUtils.runAutoSaveTask();
            MessageUtils.sendConsole(this.getMessagesManager().getAutoSaveStart());
        }, 5L, TimeUnit.SECONDS);
    }

    public void onDisable() {
        this.setPluginEnabled(false);
        HandlerList.unregisterAll((Plugin)this);
        if (this.placeholderAPIHook != null) {
            this.placeholderAPIHook.unregister();
            MessageUtils.sendDebugConsole("&aExternal placeholders unregistered!");
        }
        MessageUtils.sendConsole("-------------------------------------------");
        MessageUtils.sendConsole("&3Plugin by: &b&lLoving11ish");
        try {
            if (!this.getTeleportationManager().getTeleportQueue().isEmpty()) {
                for (Map.Entry<UUID, WrappedTask> wrappedTaskEntry : this.getTeleportationManager().getTeleportQueue().entrySet()) {
                    WrappedTask wrappedTask = wrappedTaskEntry.getValue();
                    wrappedTask.cancel();
                    MessageUtils.sendDebugConsole("&aWrapped task: " + wrappedTask.toString());
                    MessageUtils.sendDebugConsole("&aTimed task canceled successfully");
                    this.getTeleportationManager().getTeleportQueue().remove(wrappedTaskEntry.getKey());
                }
            }
            if (!AutoSaveTaskUtils.getAutoSaveTask().isCancelled()) {
                MessageUtils.sendDebugConsole("&aWrapped task: " + AutoSaveTaskUtils.getAutoSaveTask().toString());
                MessageUtils.sendDebugConsole("&aAuto save timed task canceled successfully");
                AutoSaveTaskUtils.getAutoSaveTask().cancel();
            }
            EpicHomes.getFoliaLib().getScheduler().cancelAllTasks();
            if (EpicHomes.getFoliaLib().isUnsupported()) {
                Bukkit.getScheduler().cancelTasks((Plugin)this);
                MessageUtils.sendDebugConsole("&aBukkit scheduler tasks canceled successfully");
            }
            MessageUtils.sendConsole("&3All pending teleport & background tasks stopped successfully.");
        }
        catch (Exception e) {
            MessageUtils.sendConsole("&3All pending teleport & background tasks stopped successfully.");
        }
        if (this.getUsermapStorageUtil() != null) {
            if (!this.getUsermapStorageUtil().getRawUsermapList().isEmpty()) {
                try {
                    this.getUsermapStorageUtil().saveUsermap();
                    MessageUtils.sendConsole("&3All users data saved to usermap.yml successfully!");
                }
                catch (IOException e) {
                    MessageUtils.sendConsole("error", "&4Failed to save usermap data to usermap.yml!");
                    MessageUtils.sendConsole("error", "&4See below error for reason!");
                    e.printStackTrace();
                }
            } else {
                MessageUtils.sendConsole("&3Usermap storage was empty, skipping saving!");
            }
        }
        if (this.getBukkitAudiences() != null) {
            this.getBukkitAudiences().close();
            MessageUtils.sendConsole("&3Adventure Library hook closed successfully!");
        }
        MessageUtils.sendConsole("&3Plugin Version: &d&l" + this.pluginVersion);
        MessageUtils.sendConsole("&3Has been shutdown successfully");
        MessageUtils.sendConsole("&3Goodbye!");
        MessageUtils.sendConsole("-------------------------------------------");
        this.getTeleportationManager().getTeleportQueue().clear();
        this.pluginCommands.clear();
        playerMenuUtilityMap.clear();
        this.placeholderAPIHook = null;
        this.usermapStorageUtil = null;
        this.messagesManager = null;
        this.configManager = null;
        this.usermapFileManager = null;
        this.messagesFileManager = null;
        this.teleportationManager = null;
        this.versionCheckerUtils = null;
        this.serverVersion = null;
        foliaLib = null;
        plugin = null;
    }

    public static PlayerMenuUtility getPlayerMenuUtility(Player player) {
        if (!playerMenuUtilityMap.containsKey(player)) {
            PlayerMenuUtility playerMenuUtility = new PlayerMenuUtility(player);
            playerMenuUtilityMap.put(player, playerMenuUtility);
            return playerMenuUtility;
        }
        return playerMenuUtilityMap.get(player);
    }

    public static EpicHomes getPlugin() {
        return plugin;
    }

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public BukkitAudiences getBukkitAudiences() {
        return this.bukkitAudiences;
    }

    public VersionCheckerUtils getVersionCheckerUtils() {
        return this.versionCheckerUtils;
    }

    public boolean isPluginEnabled() {
        return this.isPluginEnabled;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.isPluginEnabled = pluginEnabled;
    }

    public boolean isOnlineMode() {
        return this.isOnlineMode;
    }

    public void setOnlineMode(boolean onlineMode) {
        this.isOnlineMode = onlineMode;
    }

    public boolean isGUIEnabled() {
        return this.isGUIEnabled;
    }

    public void setGUIEnabled(boolean GUIEnabled) {
        this.isGUIEnabled = GUIEnabled;
    }

    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public void setUpdateAvailable(boolean updateAvailable) {
        this.isUpdateAvailable = updateAvailable;
    }

    public MessagesFileManager getMessagesFileManager() {
        return this.messagesFileManager;
    }

    public void setMessagesFileManager(MessagesFileManager messagesFileManager) {
        this.messagesFileManager = messagesFileManager;
    }

    public UsermapFileManager getUsermapFileManager() {
        return this.usermapFileManager;
    }

    public void setUsermapFileManager(UsermapFileManager usermapFileManager) {
        this.usermapFileManager = usermapFileManager;
    }

    public UsermapStorageUtil getUsermapStorageUtil() {
        return this.usermapStorageUtil;
    }

    public void setUsermapStorageUtil(UsermapStorageUtil usermapStorageUtil) {
        this.usermapStorageUtil = usermapStorageUtil;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public void setMessagesManager(MessagesManager messagesManager) {
        this.messagesManager = messagesManager;
    }

    public TeleportationManager getTeleportationManager() {
        return this.teleportationManager;
    }

    public void setTeleportationManager(TeleportationManager teleportationManager) {
        this.teleportationManager = teleportationManager;
    }

    static {
        playerMenuUtilityMap = new HashMap();
    }
}

