/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.paperlib.environments;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.asyncchunks.AsyncChunks;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.asyncchunks.AsyncChunksSync;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.asyncteleport.AsyncTeleport;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.asyncteleport.AsyncTeleportSync;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.bedspawnlocation.BedSpawnLocation;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.bedspawnlocation.BedSpawnLocationSync;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshot;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotBeforeSnapshots;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotNoOption;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.chunkisgenerated.ChunkIsGenerated;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.chunkisgenerated.ChunkIsGeneratedApiExists;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.chunkisgenerated.ChunkIsGeneratedUnknown;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.inventoryholdersnapshot.InventoryHolderSnapshot;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.inventoryholdersnapshot.InventoryHolderSnapshotBeforeSnapshots;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.inventoryholdersnapshot.InventoryHolderSnapshotNoOption;
import me.loving11ish.clientdetectorplus.libs.paperlib.features.inventoryholdersnapshot.InventoryHolderSnapshotResult;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;

public abstract class Environment {
    private final int minecraftVersion;
    private final int minecraftPatchVersion;
    private final int minecraftPreReleaseVersion;
    private final int minecraftReleaseCandidateVersion;
    protected AsyncChunks asyncChunksHandler = new AsyncChunksSync();
    protected AsyncTeleport asyncTeleportHandler = new AsyncTeleportSync();
    protected ChunkIsGenerated isGeneratedHandler = new ChunkIsGeneratedUnknown();
    protected BlockStateSnapshot blockStateSnapshotHandler;
    protected InventoryHolderSnapshot inventoryHolderSnapshotHandler;
    protected BedSpawnLocation bedSpawnLocationHandler = new BedSpawnLocationSync();

    public Environment() {
        this(Bukkit.getVersion());
    }

    Environment(String object) {
        Pattern pattern = Pattern.compile("(?i)\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?(?: (Pre-Release|Release Candidate) )?(\\d)?\\)");
        object = pattern.matcher((CharSequence)object);
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        if (((Matcher)object).find()) {
            MatchResult matchResult = ((Matcher)object).toMatchResult();
            try {
                n2 = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {}
            if (matchResult.groupCount() >= 3) {
                try {
                    n3 = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {}
            }
            if (matchResult.groupCount() >= 5) {
                try {
                    int n6 = Integer.parseInt(((Matcher)object).group(5));
                    if (((Matcher)object).group(4).toLowerCase(Locale.ENGLISH).contains("pre")) {
                        n4 = n6;
                    } else {
                        n5 = n6;
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.minecraftVersion = n2;
        this.minecraftPatchVersion = n3;
        this.minecraftPreReleaseVersion = n4;
        this.minecraftReleaseCandidateVersion = n5;
        if (this.isVersion(13, 1)) {
            this.isGeneratedHandler = new ChunkIsGeneratedApiExists();
        }
        if (!this.isVersion(12)) {
            this.blockStateSnapshotHandler = new BlockStateSnapshotBeforeSnapshots();
            this.inventoryHolderSnapshotHandler = new InventoryHolderSnapshotBeforeSnapshots();
            return;
        }
        this.blockStateSnapshotHandler = new BlockStateSnapshotNoOption();
        this.inventoryHolderSnapshotHandler = new InventoryHolderSnapshotNoOption();
    }

    public abstract String getName();

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n2, int n3, boolean bl) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl, false);
    }

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n2, int n3, boolean bl, boolean bl2) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl, bl2);
    }

    public CompletableFuture<Chunk> getChunkAtAsyncUrgently(World world, int n2, int n3, boolean bl) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl, true);
    }

    public CompletableFuture<Boolean> teleport(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.asyncTeleportHandler.teleportAsync(entity, location, teleportCause);
    }

    public boolean isChunkGenerated(World world, int n2, int n3) {
        return this.isGeneratedHandler.isChunkGenerated(world, n2, n3);
    }

    public BlockStateSnapshotResult getBlockState(Block block, boolean bl) {
        return this.blockStateSnapshotHandler.getBlockState(block, bl);
    }

    public InventoryHolderSnapshotResult getHolder(Inventory inventory, boolean bl) {
        return this.inventoryHolderSnapshotHandler.getHolder(inventory, bl);
    }

    public CompletableFuture<Location> getBedSpawnLocationAsync(Player player, boolean bl) {
        return this.bedSpawnLocationHandler.getBedSpawnLocationAsync(player, bl);
    }

    public boolean isVersion(int n2) {
        return this.isVersion(n2, 0);
    }

    public boolean isVersion(int n2, int n3) {
        return this.minecraftVersion > n2 || this.minecraftVersion >= n2 && this.minecraftPatchVersion >= n3;
    }

    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getMinecraftPatchVersion() {
        return this.minecraftPatchVersion;
    }

    public int getMinecraftPreReleaseVersion() {
        return this.minecraftPreReleaseVersion;
    }

    public int getMinecraftReleaseCandidateVersion() {
        return this.minecraftReleaseCandidateVersion;
    }

    public boolean isSpigot() {
        return false;
    }

    public boolean isPaper() {
        return false;
    }
}

