/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.folialib.impl;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.loving11ish.clientdetectorplus.libs.folialib.FoliaLib;
import me.loving11ish.clientdetectorplus.libs.folialib.enums.EntityTaskResult;
import me.loving11ish.clientdetectorplus.libs.folialib.impl.PlatformScheduler;
import me.loving11ish.clientdetectorplus.libs.folialib.type.Ref;
import me.loving11ish.clientdetectorplus.libs.folialib.util.FoliaLibOptions;
import me.loving11ish.clientdetectorplus.libs.folialib.util.TimeConverter;
import me.loving11ish.clientdetectorplus.libs.folialib.wrapper.task.WrappedBukkitTask;
import me.loving11ish.clientdetectorplus.libs.folialib.wrapper.task.WrappedTask;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpigotImplementation
implements PlatformScheduler {
    private final FoliaLib foliaLib;
    private final FoliaLibOptions options;
    private final Plugin plugin;
    @NotNull
    private final BukkitScheduler scheduler;

    public SpigotImplementation(FoliaLib foliaLib) {
        this.foliaLib = foliaLib;
        this.options = foliaLib.getOptions();
        this.plugin = foliaLib.getPlugin();
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Location location) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Location location, int n2) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Block block) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull World world, int n2, int n3) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull World world, int n2, int n3, int n4) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Entity entity) {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public boolean isGlobalTickThread() {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runNextTick(@NotNull Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.scheduler.runTask(this.plugin, bukkitTask -> {
            consumer.accept(this.wrapTask(bukkitTask));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAsync(@NotNull Consumer<WrappedTask> consumer) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.scheduler.runTaskAsynchronously(this.plugin, bukkitTask -> {
            consumer.accept(this.wrapTask(bukkitTask));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @Override
    public WrappedTask runLater(@NotNull Runnable runnable, long l2) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.wrapTask(spigotImplementation.scheduler.runTaskLater(this.plugin, runnable, l2));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runLater(@NotNull Consumer<WrappedTask> consumer, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.scheduler.runTaskLater(this.plugin, bukkitTask -> {
            consumer.accept(this.wrapTask(bukkitTask));
            completableFuture.complete(null);
        }, l2);
        return completableFuture;
    }

    @Override
    public WrappedTask runLater(@NotNull Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runLater(runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runLater(@NotNull Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runLater(consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runLaterAsync(@NotNull Runnable runnable, long l2) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.wrapTask(spigotImplementation.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, l2));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runLaterAsync(@NotNull Consumer<WrappedTask> consumer, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.scheduler.runTaskLaterAsynchronously(this.plugin, bukkitTask -> {
            consumer.accept(this.wrapTask(bukkitTask));
            completableFuture.complete(null);
        }, l2);
        return completableFuture;
    }

    @Override
    public WrappedTask runLaterAsync(@NotNull Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runLaterAsync(runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runLaterAsync(@NotNull Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runLaterAsync(consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runTimer(@NotNull Runnable runnable, long l2, long l3) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.wrapTask(spigotImplementation.scheduler.runTaskTimer(this.plugin, runnable, l2, l3));
    }

    @Override
    public void runTimer(@NotNull Consumer<WrappedTask> consumer, long l2, long l3) {
        this.scheduler.runTaskTimer(this.plugin, bukkitTask -> consumer.accept(this.wrapTask(bukkitTask)), l2, l3);
    }

    @Override
    public WrappedTask runTimer(@NotNull Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runTimer(runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runTimer(@NotNull Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runTimer(consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public WrappedTask runTimerAsync(@NotNull Runnable runnable, long l2, long l3) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.wrapTask(spigotImplementation.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, l2, l3));
    }

    @Override
    public void runTimerAsync(@NotNull Consumer<WrappedTask> consumer, long l2, long l3) {
        this.scheduler.runTaskTimerAsynchronously(this.plugin, bukkitTask -> consumer.accept(this.wrapTask(bukkitTask)), l2, l3);
    }

    @Override
    public WrappedTask runTimerAsync(@NotNull Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runTimerAsync(runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runTimerAsync(@NotNull Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runTimerAsync(consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAtLocation(Location location, @NotNull Consumer<WrappedTask> consumer) {
        return this.runNextTick(consumer);
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, @NotNull Runnable runnable, long l2) {
        return this.runLater(runnable, l2);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAtLocationLater(Location location, @NotNull Consumer<WrappedTask> consumer, long l2) {
        return this.runLater(consumer, l2);
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, @NotNull Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runAtLocationLater(location, runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAtLocationLater(Location location, @NotNull Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runAtLocationLater(location, consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, @NotNull Runnable runnable, long l2, long l3) {
        return this.runTimer(runnable, l2, l3);
    }

    @Override
    public void runAtLocationTimer(Location location, @NotNull Consumer<WrappedTask> consumer, long l2, long l3) {
        this.runTimer(consumer, l2, l3);
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, @NotNull Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runAtLocationTimer(location, runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runAtLocationTimer(Location location, @NotNull Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runAtLocationTimer(location, consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    @NotNull
    public CompletableFuture<EntityTaskResult> runAtEntity(Entity object, @NotNull Consumer<WrappedTask> consumer) {
        object = new CompletableFuture();
        this.runNextTick(arg_0 -> SpigotImplementation.lambda$runAtEntity$6(consumer, (CompletableFuture)object, arg_0));
        return object;
    }

    @Override
    @NotNull
    public CompletableFuture<EntityTaskResult> runAtEntityWithFallback(Entity entity, @NotNull Consumer<WrappedTask> consumer, Runnable runnable) {
        CompletableFuture<EntityTaskResult> completableFuture = new CompletableFuture<EntityTaskResult>();
        SpigotImplementation spigotImplementation = this;
        spigotImplementation.runNextTick(wrappedTask -> {
            if (this.isValid(entity)) {
                consumer.accept((WrappedTask)wrappedTask);
                completableFuture.complete(EntityTaskResult.SUCCESS);
                return;
            }
            runnable.run();
            completableFuture.complete(EntityTaskResult.ENTITY_RETIRED);
        });
        return completableFuture;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @NotNull Runnable runnable, long l2) {
        return this.runAtEntityLater(entity, runnable, null, l2);
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @NotNull Runnable runnable, Runnable runnable2, long l2) {
        if (!this.isValid(entity)) {
            if (runnable2 != null) {
                runnable2.run();
            }
            return null;
        }
        return this.runLater(runnable, l2);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @NotNull Consumer<WrappedTask> consumer, long l2) {
        return this.runAtEntityLater(entity, consumer, null, l2);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @NotNull Consumer<WrappedTask> consumer, @Nullable Runnable runnable, long l2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (!this.isValid(entity)) {
            completableFuture.complete(null);
            if (runnable != null) {
                runnable.run();
            }
            return completableFuture;
        }
        SpigotImplementation spigotImplementation = this;
        spigotImplementation.runLater((WrappedTask wrappedTask) -> {
            if (!this.isValid(entity)) {
                if (runnable != null) {
                    runnable.run();
                }
                completableFuture.complete(null);
                return;
            }
            consumer.accept((WrappedTask)wrappedTask);
            completableFuture.complete(null);
        }, l2);
        return completableFuture;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, @NotNull Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.runAtEntityLater(entity, runnable, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runAtEntityLater(Entity entity, @NotNull Consumer<WrappedTask> consumer, long l2, TimeUnit timeUnit) {
        return this.runAtEntityLater(entity, consumer, TimeConverter.toTicks(l2, timeUnit));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @NotNull Runnable runnable, long l2, long l3) {
        return this.runAtEntityTimer(entity, runnable, null, l2, l3);
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity object, @NotNull Runnable runnable, @Nullable Runnable runnable2, long l2, long l3) {
        if (!this.isValid((Entity)object)) {
            if (runnable2 != null) {
                runnable2.run();
            }
            return null;
        }
        Ref<Entity> ref = new Ref<Entity>();
        SpigotImplementation spigotImplementation = this;
        object = spigotImplementation.runTimer(() -> spigotImplementation.lambda$runAtEntityTimer$9(ref, (Entity)object, runnable2, runnable), l2, l3);
        ref.set((Entity)object);
        return object;
    }

    @Override
    public void runAtEntityTimer(Entity entity, @NotNull Consumer<WrappedTask> consumer, long l2, long l3) {
        this.runAtEntityTimer(entity, consumer, null, l2, l3);
    }

    @Override
    public void runAtEntityTimer(Entity entity, @NotNull Consumer<WrappedTask> consumer, Runnable runnable, long l2, long l3) {
        if (!this.isValid(entity)) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        SpigotImplementation spigotImplementation = this;
        spigotImplementation.runTimer((WrappedTask wrappedTask) -> {
            if (!this.isValid(entity)) {
                if (runnable != null) {
                    runnable.run();
                }
                return;
            }
            consumer.accept((WrappedTask)wrappedTask);
        }, l2, l3);
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, @NotNull Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.runAtEntityTimer(entity, runnable, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void runAtEntityTimer(Entity entity, @NotNull Consumer<WrappedTask> consumer, long l2, long l3, TimeUnit timeUnit) {
        this.runAtEntityTimer(entity, consumer, TimeConverter.toTicks(l2, timeUnit), TimeConverter.toTicks(l3, timeUnit));
    }

    @Override
    public void cancelTask(WrappedTask wrappedTask) {
        wrappedTask.cancel();
    }

    @Override
    public void cancelAllTasks() {
        this.scheduler.cancelTasks(this.plugin);
    }

    @Override
    public List<WrappedTask> getAllTasks() {
        return this.scheduler.getPendingTasks().stream().filter(bukkitTask -> bukkitTask.getOwner().equals(this.plugin)).map(this::wrapTask).collect(Collectors.toList());
    }

    @Override
    public List<WrappedTask> getAllServerTasks() {
        return this.scheduler.getPendingTasks().stream().map(this::wrapTask).collect(Collectors.toList());
    }

    @Override
    public Player getPlayer(String string) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.getPlayerFromMainThread(() -> this.plugin.getServer().getPlayer(string));
    }

    @Override
    public Player getPlayerExact(String string) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.getPlayerFromMainThread(() -> this.plugin.getServer().getPlayerExact(string));
    }

    @Override
    public Player getPlayer(UUID uUID) {
        SpigotImplementation spigotImplementation = this;
        return spigotImplementation.getPlayerFromMainThread(() -> this.plugin.getServer().getPlayer(uUID));
    }

    private Player getPlayerFromMainThread(Supplier<Player> object) {
        if (this.plugin.getServer().isPrimaryThread()) {
            return object.get();
        }
        try {
            return (Player)this.scheduler.callSyncMethod(this.plugin, ((Supplier)object)::get).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            object = exception;
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return this.teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause object) {
        object = new CompletableFuture();
        this.runAtEntity(entity, arg_0 -> this.lambda$teleportAsync$15(entity, location, (CompletableFuture)object, arg_0));
        return object;
    }

    @Override
    public WrappedTask wrapTask(@NotNull Object object) {
        Objects.requireNonNull(object, "nativeTask cannot be null");
        if (!(object instanceof BukkitTask)) {
            throw new IllegalArgumentException("The nativeTask provided must be a BukkitTask. Got: " + object.getClass().getName() + " instead.");
        }
        return new WrappedBukkitTask((BukkitTask)object);
    }

    private boolean isValid(Entity entity) {
        boolean bl = !this.options.useIsValidOnNonFolia();
        if (bl) {
            return true;
        }
        if (entity.isValid()) {
            return !(entity instanceof Player) || ((Player)entity).isOnline();
        }
        return entity instanceof Projectile && !entity.isDead();
    }

    private /* synthetic */ void lambda$teleportAsync$15(Entity entity, Location location, CompletableFuture completableFuture, WrappedTask wrappedTask) {
        if (this.isValid(entity)) {
            boolean bl = entity.teleport(location);
            completableFuture.complete(bl);
            return;
        }
        completableFuture.complete(Boolean.FALSE);
    }

    private /* synthetic */ void lambda$runAtEntityTimer$9(Ref object, Entity entity, Runnable runnable, Runnable runnable2) {
        if ((object = (WrappedTask)((Ref)object).get()) != null && !this.isValid(entity)) {
            object.cancel();
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        runnable2.run();
    }

    private static /* synthetic */ void lambda$runAtEntity$6(Consumer consumer, CompletableFuture completableFuture, WrappedTask wrappedTask) {
        consumer.accept(wrappedTask);
        completableFuture.complete(EntityTaskResult.SUCCESS);
    }
}

