/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.folialib.enums;

import java.util.function.Supplier;
import me.loving11ish.clientdetectorplus.libs.folialib.util.ImplementationTestsUtil;

public enum ImplementationType {
    FOLIA("FoliaImplementation", new Supplier[0], "io.papermc.paper.threadedregions.RegionizedServer"),
    PAPER("PaperImplementation", new Supplier[]{ImplementationTestsUtil::isTaskConsumersSupported}, "com.destroystokyo.paper.PaperConfig", "io.papermc.paper.configuration.Configuration"),
    LEGACY_PAPER("LegacyPaperImplementation", new Supplier[0], "com.destroystokyo.paper.PaperConfig", "io.papermc.paper.configuration.Configuration"),
    SPIGOT("SpigotImplementation", new Supplier[]{ImplementationTestsUtil::isTaskConsumersSupported}, "org.spigotmc.SpigotConfig"),
    LEGACY_SPIGOT("LegacySpigotImplementation", new Supplier[0], "org.spigotmc.SpigotConfig"),
    UNKNOWN("UnsupportedImplementation", new Supplier[0], new String[0]);

    private final String implementationClassName;
    private final Supplier<Boolean>[] tests;
    private final String[] classNames;

    private ImplementationType(String string2, Supplier<Boolean>[] supplierArray, String ... stringArray) {
        this.implementationClassName = string2;
        this.tests = supplierArray;
        this.classNames = stringArray;
    }

    public final String getImplementationClassName() {
        return this.implementationClassName;
    }

    public final Supplier<Boolean>[] getTests() {
        return this.tests;
    }

    public final String[] getClassNames() {
        return this.classNames;
    }

    public final boolean selfCheck() {
        String[] stringArray;
        for (Supplier<Boolean> supplier : this.getTests()) {
            if (supplier.get().booleanValue()) continue;
            return false;
        }
        String[] stringArray2 = stringArray = this.getClassNames();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            try {
                Class.forName(string);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return false;
    }
}

