/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.folialib;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import me.loving11ish.clientdetectorplus.libs.folialib.enums.ImplementationType;
import me.loving11ish.clientdetectorplus.libs.folialib.impl.PlatformScheduler;
import me.loving11ish.clientdetectorplus.libs.folialib.util.FoliaLibOptions;
import me.loving11ish.clientdetectorplus.libs.folialib.util.InvalidTickDelayNotifier;
import org.bukkit.plugin.Plugin;

public class FoliaLib {
    private final Plugin plugin;
    private final ImplementationType implementationType;
    private final PlatformScheduler scheduler;
    private FoliaLibOptions options;
    private InvalidTickDelayNotifier invalidTickDelayNotifier;

    public FoliaLib(Plugin plugin) {
        this(plugin, new FoliaLibOptions());
    }

    public FoliaLib(Plugin object, FoliaLibOptions object2) {
        this.plugin = object;
        this.options = object2;
        this.invalidTickDelayNotifier = new InvalidTickDelayNotifier(object.getLogger(), this.options);
        object = ImplementationType.UNKNOWN;
        for (ImplementationType implementationType : ImplementationType.values()) {
            if (!implementationType.selfCheck()) continue;
            object = implementationType;
            break;
        }
        this.implementationType = object;
        this.scheduler = this.createServerImpl(this.implementationType.getImplementationClassName());
        if (this.scheduler == null) {
            throw new IllegalStateException("Failed to create server implementation. Please report this to the FoliaLib GitHub issues page. Forks of server software may not all be supported. If you are using an unofficial fork, please report this to the fork's developers first.");
        }
        String string = "com,tcoded,folialib,".replace(",", ".");
        if (this.getClass().getName().startsWith(string)) {
            Logger logger = this.plugin.getLogger();
            logger.severe("****************************************************************");
            logger.severe("FoliaLib is not relocated correctly! This will cause conflicts");
            logger.severe("with other plugins using FoliaLib. Please contact the developers");
            logger.severe(String.format("of '%s' and inform them of this issue immediately!", this.plugin.getDescription().getName()));
            logger.severe("****************************************************************");
        }
    }

    public ImplementationType getImplType() {
        return this.implementationType;
    }

    @Deprecated
    public PlatformScheduler getImpl() {
        return this.getScheduler();
    }

    public PlatformScheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isFolia() {
        return this.implementationType == ImplementationType.FOLIA;
    }

    public boolean isPaper() {
        return this.implementationType == ImplementationType.PAPER || this.implementationType == ImplementationType.LEGACY_PAPER;
    }

    public boolean isSpigot() {
        return this.implementationType == ImplementationType.SPIGOT || this.implementationType == ImplementationType.LEGACY_SPIGOT;
    }

    public boolean isUnsupported() {
        return this.implementationType == ImplementationType.UNKNOWN;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Deprecated
    public void disableInvalidTickValueWarning() {
        this.getOptions().disableNotifications();
    }

    @Deprecated
    public void enableInvalidTickValueDebug() {
        this.getOptions().enableInvalidTickDebugMode();
    }

    public FoliaLibOptions getOptions() {
        return this.options;
    }

    @Deprecated
    public InvalidTickDelayNotifier getInvalidTickDelayNotifier() {
        return this.invalidTickDelayNotifier;
    }

    private PlatformScheduler createServerImpl(String object) {
        String string = this.getClass().getPackage().getName() + ".impl.";
        try {
            return (PlatformScheduler)Class.forName(string + (String)object).getConstructor(this.getClass()).newInstance(this);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            object = reflectiveOperationException;
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }
}

