/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Index<K, V> {
    private final Map<K, V> keyToValue;
    private final Map<V, K> valueToKey;

    private Index(Map<K, V> map, Map<V, K> map2) {
        this.keyToValue = map;
        this.valueToKey = map2;
    }

    @NotNull
    public static <K, V extends Enum<V>> Index<K, V> create(Class<V> clazz, @NotNull Function<? super V, ? extends K> function) {
        return Index.create(clazz, function, (Enum[])((Enum[])clazz.getEnumConstants()));
    }

    @SafeVarargs
    @NotNull
    public static <K, V extends Enum<V>> Index<K, V> create(Class<V> clazz, @NotNull Function<? super V, ? extends K> function, V ... VArray) {
        return Index.create(VArray, (int n2) -> new EnumMap(clazz), function);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Index<K, V> create(@NotNull Function<? super V, ? extends K> function, V ... VArray) {
        return Index.create(VArray, HashMap::new, function);
    }

    @NotNull
    public static <K, V> Index<K, V> create(@NotNull Function<? super V, ? extends K> function, @NotNull List<V> list) {
        return Index.create(list, HashMap::new, function);
    }

    @NotNull
    private static <K, V> Index<K, V> create(V[] VArray, IntFunction<Map<V, K>> intFunction, @NotNull Function<? super V, ? extends K> function) {
        return Index.create(Arrays.asList(VArray), intFunction, function);
    }

    @NotNull
    private static <K, V> Index<K, V> create(List<V> list, IntFunction<Map<V, K>> object, @NotNull Function<? super V, ? extends K> function) {
        int n2 = list.size();
        HashMap<K, V> hashMap = new HashMap<K, V>(n2);
        object = object.apply(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2 = list.get(i2);
            K k2 = function.apply(v2);
            if (hashMap.putIfAbsent(k2, v2) != null) {
                throw new IllegalStateException(String.format("Key %s already mapped to value %s", k2, hashMap.get(k2)));
            }
            if (object.putIfAbsent(v2, k2) == null) continue;
            throw new IllegalStateException(String.format("Value %s already mapped to key %s", v2, object.get(v2)));
        }
        return new Index(Collections.unmodifiableMap(hashMap), Collections.unmodifiableMap(object));
    }

    @NotNull
    public final Set<K> keys() {
        return Collections.unmodifiableSet(this.keyToValue.keySet());
    }

    @Nullable
    public final K key(@NotNull V v2) {
        return this.valueToKey.get(v2);
    }

    @NotNull
    public final K keyOrThrow(@NotNull V v2) {
        K k2 = this.key(v2);
        if (k2 == null) {
            throw new NoSuchElementException("There is no key for value " + v2);
        }
        return k2;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public final K keyOr(@NotNull V object, @Nullable K k2) {
        if ((object = this.key(object)) == null) {
            return k2;
        }
        return (K)object;
    }

    @NotNull
    public final Set<V> values() {
        return Collections.unmodifiableSet(this.valueToKey.keySet());
    }

    @Nullable
    public final V value(@NotNull K k2) {
        return this.keyToValue.get(k2);
    }

    @NotNull
    public final V valueOrThrow(@NotNull K k2) {
        V v2 = this.value(k2);
        if (v2 == null) {
            throw new NoSuchElementException("There is no value for key " + k2);
        }
        return v2;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public final V valueOr(@NotNull K object, @Nullable V v2) {
        if ((object = this.value(object)) == null) {
            return v2;
        }
        return (V)object;
    }

    @NotNull
    public final Map<K, V> keyToValue() {
        return Collections.unmodifiableMap(this.keyToValue);
    }

    @NotNull
    public final Map<V, K> valueToKey() {
        return Collections.unmodifiableMap(this.valueToKey);
    }
}

