/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.util;

import java.util.Objects;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.HSVLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.ShadyPines;
import org.jetbrains.annotations.Nullable;

final class HSVLikeImpl
implements HSVLike {
    private final float h;
    private final float s;
    private final float v;

    HSVLikeImpl(float f2, float f3, float f4) {
        HSVLikeImpl.requireInsideRange(f2, "h");
        HSVLikeImpl.requireInsideRange(f3, "s");
        HSVLikeImpl.requireInsideRange(f4, "v");
        this.h = f2;
        this.s = f3;
        this.v = f4;
    }

    @Override
    public final float h() {
        return this.h;
    }

    @Override
    public final float s() {
        return this.s;
    }

    @Override
    public final float v() {
        return this.v;
    }

    private static void requireInsideRange(float f2, String string) {
        if (f2 < 0.0f || 1.0f < f2) {
            throw new IllegalArgumentException(string + " (" + f2 + ") is not inside the required range: [0,1]");
        }
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HSVLikeImpl)) {
            return false;
        }
        object = (HSVLikeImpl)object;
        return ShadyPines.equals(((HSVLikeImpl)object).h, this.h) && ShadyPines.equals(((HSVLikeImpl)object).s, this.s) && ShadyPines.equals(((HSVLikeImpl)object).v, this.v);
    }

    public final int hashCode() {
        return Objects.hash(Float.valueOf(this.h), Float.valueOf(this.s), Float.valueOf(this.v));
    }

    public final String toString() {
        return Internals.toString(this);
    }
}

