/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TranslatableComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.renderer.TranslatableComponentRenderer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation.GlobalTranslator;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation.Translator;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.TriState;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GlobalTranslatorImpl
implements GlobalTranslator {
    private static final Key NAME = Key.key("adventure", "global");
    static final GlobalTranslatorImpl INSTANCE = new GlobalTranslatorImpl();
    final TranslatableComponentRenderer<Locale> renderer = TranslatableComponentRenderer.usingTranslationSource(this);
    private final Set<Translator> sources = Collections.newSetFromMap(new ConcurrentHashMap());

    private GlobalTranslatorImpl() {
    }

    @Override
    @NotNull
    public final Key name() {
        return NAME;
    }

    @Override
    @NotNull
    public final Iterable<? extends Translator> sources() {
        return Collections.unmodifiableSet(this.sources);
    }

    @Override
    public final boolean addSource(@NotNull Translator translator) {
        Objects.requireNonNull(translator, "source");
        if (translator == this) {
            throw new IllegalArgumentException("GlobalTranslationSource");
        }
        return this.sources.add(translator);
    }

    @Override
    public final boolean removeSource(@NotNull Translator translator) {
        Objects.requireNonNull(translator, "source");
        return this.sources.remove(translator);
    }

    @Override
    @NotNull
    public final TriState hasAnyTranslations() {
        if (!this.sources.isEmpty()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    @Nullable
    public final MessageFormat translate(@NotNull String string, @NotNull Locale locale) {
        Objects.requireNonNull(string, "key");
        Objects.requireNonNull(locale, "locale");
        for (Translator translator : this.sources) {
            MessageFormat object = translator.translate(string, locale);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    @Nullable
    public final Component translate(@NotNull TranslatableComponent translatableComponent, @NotNull Locale locale) {
        Objects.requireNonNull(translatableComponent, "component");
        Objects.requireNonNull(locale, "locale");
        for (Translator translator : this.sources) {
            Component object = translator.translate(translatableComponent, locale);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("sources", this.sources));
    }
}

