/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation.TranslationLocales;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation.TranslationStore;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.TriState;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.Examinable;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTranslationStore<T>
implements TranslationStore<T>,
Examinable {
    @NotNull
    private final Key name;
    private final Map<String, Translation> translations = new ConcurrentHashMap<String, Translation>();
    @NotNull
    private volatile Locale defaultLocale = Locale.US;

    protected AbstractTranslationStore(@NotNull Key key) {
        this.name = Objects.requireNonNull(key, "name");
    }

    @Nullable
    protected T translationValue(@NotNull String object, @NotNull Locale locale) {
        if ((object = this.translations.get(Objects.requireNonNull(object, "key"))) == null) {
            return null;
        }
        return (T)((Translation)object).translate(Objects.requireNonNull(locale, "locale"));
    }

    @Override
    public final boolean contains(@NotNull String string) {
        return this.translations.containsKey(string);
    }

    @Override
    public final boolean contains(@NotNull String object, @NotNull Locale locale) {
        if ((object = this.translations.get(Objects.requireNonNull(object, "key"))) == null) {
            return false;
        }
        return ((Translation)object).translations.get(Objects.requireNonNull(locale, "locale")) != null;
    }

    @Override
    public final boolean canTranslate(@NotNull String object, @NotNull Locale locale) {
        if ((object = this.translations.get(Objects.requireNonNull(object, "key"))) == null) {
            return false;
        }
        return ((Translation)object).translate(Objects.requireNonNull(locale, "locale")) != null;
    }

    @Override
    public final void defaultLocale(@NotNull Locale locale) {
        this.defaultLocale = Objects.requireNonNull(locale, "locale");
    }

    @Override
    public final void register(@NotNull String string2, @NotNull Locale locale, @NotNull T t2) {
        this.translations.computeIfAbsent(string2, string -> new Translation((String)string)).register(locale, t2);
    }

    @Override
    public final void registerAll(@NotNull Locale locale, @NotNull Map<String, T> map) {
        this.registerAll(locale, map.keySet(), map::get);
    }

    @Override
    public final void registerAll(@NotNull Locale locale, @NotNull Set<String> object, Function<String, T> function) {
        IllegalArgumentException illegalArgumentException = null;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                this.register(string, locale, function.apply(string));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                if (illegalArgumentException == null) {
                    illegalArgumentException = illegalArgumentException2;
                }
                ++n2;
            }
        }
        if (illegalArgumentException != null) {
            if (n2 == 1) {
                throw illegalArgumentException;
            }
            if (n2 > 1) {
                throw new IllegalArgumentException(String.format("Invalid key (and %d more)", n2 - 1), illegalArgumentException);
            }
        }
    }

    @Override
    public final void unregister(@NotNull String string) {
        this.translations.remove(string);
    }

    @Override
    @NotNull
    public final Key name() {
        return this.name;
    }

    @Override
    @NotNull
    public final TriState hasAnyTranslations() {
        return TriState.byBoolean(!this.translations.isEmpty());
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("translations", this.translations));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractTranslationStore)) {
            return false;
        }
        object = (AbstractTranslationStore)object;
        return this.name.equals(((AbstractTranslationStore)object).name) && this.translations.equals(((AbstractTranslationStore)object).translations) && this.defaultLocale.equals(((AbstractTranslationStore)object).defaultLocale);
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.translations, this.defaultLocale);
    }

    @NotNull
    public final String toString() {
        return Internals.toString(this);
    }

    private final class Translation
    implements Examinable {
        private final String key;
        private final Map<Locale, T> translations;

        private Translation(String string) {
            this.key = Objects.requireNonNull(string, "key");
            this.translations = new ConcurrentHashMap();
        }

        @Nullable
        private T translate(@NotNull Locale locale) {
            Object t2 = this.translations.get(Objects.requireNonNull(locale, "locale"));
            if (t2 == null && (t2 = this.translations.get(new Locale(locale.getLanguage()))) == null && (t2 = this.translations.get(AbstractTranslationStore.this.defaultLocale)) == null) {
                t2 = this.translations.get(TranslationLocales.global());
            }
            return t2;
        }

        private void register(@NotNull Locale locale, @NotNull T t2) {
            if (this.translations.putIfAbsent(Objects.requireNonNull(locale, "locale"), Objects.requireNonNull(t2, "translation")) != null) {
                throw new IllegalArgumentException(String.format("Translation already exists: %s for %s", this.key, locale));
            }
        }

        @Override
        @NotNull
        public final Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("translations", this.translations));
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Translation)) {
                return false;
            }
            object = (Translation)object;
            return this.key.equals(((Translation)object).key) && this.translations.equals(((Translation)object).translations);
        }

        public final int hashCode() {
            return Objects.hash(this.key, this.translations);
        }

        public final String toString() {
            return Internals.toString(this);
        }
    }

    public static abstract class StringBased<T>
    extends AbstractTranslationStore<T>
    implements TranslationStore.StringBased<T> {
        private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("'");

        protected StringBased(@NotNull Key key) {
            super(key);
        }

        @NotNull
        protected abstract T parse(@NotNull String var1, @NotNull Locale var2);

        @Override
        public final void registerAll(@NotNull Locale locale, @NotNull Path object, boolean bl) {
            try {
                block8: {
                    block7: {
                        object = Files.newBufferedReader((Path)object, StandardCharsets.UTF_8);
                        try {
                            this.registerAll(locale, new PropertyResourceBundle((Reader)object), bl);
                            if (object == null) break block7;
                        }
                        catch (Throwable throwable) {
                            if (object != null) {
                                try {
                                    ((BufferedReader)object).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        break block8;
                    }
                    return;
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
        }

        @Override
        public final void registerAll(@NotNull Locale locale, @NotNull ResourceBundle resourceBundle, boolean bl) {
            this.registerAll(locale, resourceBundle.keySet(), string -> {
                resourceBundle = ((ResourceBundle)resourceBundle).getString((String)string);
                return this.parse((String)(bl ? SINGLE_QUOTE_PATTERN.matcher((CharSequence)((Object)resourceBundle)).replaceAll("''") : resourceBundle), locale);
            });
        }
    }
}

