/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.legacy;

import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.builder.AbstractBuilder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.flattener.ComponentFlattener;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.ComponentSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.legacy.CharacterAndFormat;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.legacy.LegacyComponentSerializerImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.legacy.LegacyFormat;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.Buildable;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LegacyComponentSerializer
extends ComponentSerializer<Component, TextComponent, String>,
Buildable<LegacyComponentSerializer, Builder> {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';
    public static final char HEX_CHAR = '#';

    @NotNull
    public static LegacyComponentSerializer legacySection() {
        return LegacyComponentSerializerImpl.Instances.SECTION;
    }

    @NotNull
    public static LegacyComponentSerializer legacyAmpersand() {
        return LegacyComponentSerializerImpl.Instances.AMPERSAND;
    }

    @NotNull
    public static LegacyComponentSerializer legacy(char c2) {
        if (c2 == '\u00a7') {
            return LegacyComponentSerializer.legacySection();
        }
        if (c2 == '&') {
            return LegacyComponentSerializer.legacyAmpersand();
        }
        return LegacyComponentSerializer.builder().character(c2).build();
    }

    @Nullable
    public static LegacyFormat parseChar(char c2) {
        return LegacyComponentSerializerImpl.legacyFormat(c2);
    }

    @NotNull
    public static Builder builder() {
        return new LegacyComponentSerializerImpl.BuilderImpl();
    }

    @Override
    @NotNull
    public TextComponent deserialize(@NotNull String var1);

    @Override
    @NotNull
    public String serialize(@NotNull Component var1);

    public static interface Builder
    extends AbstractBuilder<LegacyComponentSerializer>,
    Buildable.Builder<LegacyComponentSerializer> {
        @NotNull
        public Builder character(char var1);

        @NotNull
        public Builder hexCharacter(char var1);

        @NotNull
        public Builder extractUrls();

        @NotNull
        public Builder extractUrls(@NotNull Pattern var1);

        @NotNull
        public Builder extractUrls(@Nullable Style var1);

        @NotNull
        public Builder extractUrls(@NotNull Pattern var1, @Nullable Style var2);

        @NotNull
        public Builder hexColors();

        @NotNull
        public Builder useUnusualXRepeatedCharacterHexFormat();

        @NotNull
        public Builder flattener(@NotNull ComponentFlattener var1);

        @NotNull
        public Builder formats(@NotNull List<CharacterAndFormat> var1);

        @Override
        @NotNull
        public LegacyComponentSerializer build();
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        @PlatformAPI
        @ApiStatus.Internal
        @NotNull
        public LegacyComponentSerializer legacyAmpersand();

        @PlatformAPI
        @ApiStatus.Internal
        @NotNull
        public LegacyComponentSerializer legacySection();

        @PlatformAPI
        @ApiStatus.Internal
        @NotNull
        public Consumer<Builder> legacy();
    }
}

