/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.legacyimpl;

import java.io.IOException;
import java.util.UUID;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.TagStringIO;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.api.BinaryTagHolder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.LegacyHoverEventSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.Codec;
import org.jetbrains.annotations.NotNull;

final class NBTLegacyHoverEventSerializerImpl
implements LegacyHoverEventSerializer {
    static final NBTLegacyHoverEventSerializerImpl INSTANCE = new NBTLegacyHoverEventSerializerImpl();
    private static final TagStringIO SNBT_IO = TagStringIO.get();
    private static final Codec<CompoundBinaryTag, String, IOException, IOException> SNBT_CODEC = Codec.codec(SNBT_IO::asCompound, SNBT_IO::asString);
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";

    private NBTLegacyHoverEventSerializerImpl() {
    }

    @Override
    public final @NotNull HoverEvent.ShowItem deserializeShowItem(@NotNull Component examinable) {
        NBTLegacyHoverEventSerializerImpl.assertTextComponent((Component)examinable);
        examinable = SNBT_CODEC.decode(((TextComponent)examinable).content());
        CompoundBinaryTag compoundBinaryTag = examinable.getCompound(ITEM_TAG);
        return HoverEvent.ShowItem.showItem(Key.key(examinable.getString("id")), (int)examinable.getByte(ITEM_COUNT, (byte)1), compoundBinaryTag == CompoundBinaryTag.empty() ? null : BinaryTagHolder.encode(compoundBinaryTag, SNBT_CODEC));
    }

    @Override
    @NotNull
    public final Component serializeShowItem(@NotNull HoverEvent.ShowItem examinable) {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", ((HoverEvent.ShowItem)examinable).item().asString())).putByte(ITEM_COUNT, (byte)((HoverEvent.ShowItem)examinable).count());
        if ((examinable = ((HoverEvent.ShowItem)examinable).nbt()) != null) {
            builder.put(ITEM_TAG, examinable.get(SNBT_CODEC));
        }
        return Component.text(SNBT_CODEC.encode(builder.build()));
    }

    @Override
    public final @NotNull HoverEvent.ShowEntity deserializeShowEntity(@NotNull Component examinable, Codec.Decoder<Component, String, ? extends RuntimeException> decoder) {
        NBTLegacyHoverEventSerializerImpl.assertTextComponent((Component)examinable);
        examinable = SNBT_CODEC.decode(((TextComponent)examinable).content());
        return HoverEvent.ShowEntity.showEntity(Key.key(examinable.getString(ENTITY_TYPE)), UUID.fromString(examinable.getString("id")), decoder.decode(examinable.getString(ENTITY_NAME)));
    }

    @Override
    @NotNull
    public final Component serializeShowEntity(@NotNull HoverEvent.ShowEntity examinable, Codec.Encoder<Component, String, ? extends RuntimeException> encoder) {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", examinable.id().toString())).putString(ENTITY_TYPE, examinable.type().asString());
        if ((examinable = examinable.name()) != null) {
            builder.putString(ENTITY_NAME, encoder.encode((Component)examinable));
        }
        return Component.text(SNBT_CODEC.encode(builder.build()));
    }

    private static void assertTextComponent(Component component) {
        if (!(component instanceof TextComponent) || !component.children().isEmpty()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }
}

