/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TranslationArgument;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.SerializerFactory;

final class TranslationArgumentSerializer
extends TypeAdapter<TranslationArgument> {
    private final Gson gson;

    static TypeAdapter<TranslationArgument> create(Gson gson) {
        return new TranslationArgumentSerializer(gson).nullSafe();
    }

    private TranslationArgumentSerializer(Gson gson) {
        this.gson = gson;
    }

    public final void write(JsonWriter jsonWriter, TranslationArgument object) {
        if ((object = object.value()) instanceof Boolean) {
            jsonWriter.value((Boolean)object);
            return;
        }
        if (object instanceof Number) {
            jsonWriter.value((Number)object);
            return;
        }
        if (object instanceof Component) {
            this.gson.toJson(object, SerializerFactory.COMPONENT_TYPE, jsonWriter);
            return;
        }
        throw new IllegalStateException("Unable to serialize translatable argument of type " + object.getClass() + ": " + object);
    }

    public final TranslationArgument read(JsonReader jsonReader) {
        switch (jsonReader.peek()) {
            case BOOLEAN: {
                return TranslationArgument.bool(jsonReader.nextBoolean());
            }
            case NUMBER: {
                return TranslationArgument.numeric((Number)this.gson.fromJson(jsonReader, Number.class));
            }
        }
        return TranslationArgument.component((ComponentLike)this.gson.fromJson(jsonReader, SerializerFactory.COMPONENT_TYPE));
    }
}

