/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.Locale;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.NamedTextColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextColorSerializer
extends TypeAdapter<TextColor> {
    static final TypeAdapter<TextColor> INSTANCE = new TextColorSerializer(false).nullSafe();
    static final TypeAdapter<TextColor> DOWNSAMPLE_COLOR = new TextColorSerializer(true).nullSafe();
    private final boolean downsampleColor;

    private TextColorSerializer(boolean bl) {
        this.downsampleColor = bl;
    }

    public final void write(JsonWriter jsonWriter, TextColor textColor) {
        if (textColor instanceof NamedTextColor) {
            jsonWriter.value(NamedTextColor.NAMES.key((NamedTextColor)textColor));
            return;
        }
        if (this.downsampleColor) {
            jsonWriter.value(NamedTextColor.NAMES.key(NamedTextColor.nearestTo(textColor)));
            return;
        }
        jsonWriter.value(TextColorSerializer.asUpperCaseHexString(textColor));
    }

    private static String asUpperCaseHexString(TextColor textColor) {
        return String.format(Locale.ROOT, "%c%06X", Character.valueOf('#'), textColor.value());
    }

    @Nullable
    public final TextColor read(JsonReader object) {
        if ((object = TextColorSerializer.fromString(object.nextString())) == null) {
            return null;
        }
        if (this.downsampleColor) {
            return NamedTextColor.nearestTo((TextColor)object);
        }
        return object;
    }

    @Nullable
    static TextColor fromString(@NotNull String string) {
        if (string.startsWith("#")) {
            return TextColor.fromHexString(string);
        }
        return NamedTextColor.NAMES.value(string);
    }
}

