/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.HashMap;
import java.util.Map;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.api.BinaryTagHolder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.DataComponentValue;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.GsonDataComponentValue;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.SerializerFactory;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clientdetectorplus.libs.adventure.option.OptionState;

final class ShowItemSerializer
extends TypeAdapter<HoverEvent.ShowItem> {
    private static final String LEGACY_SHOW_ITEM_TAG = "tag";
    private static final String DATA_COMPONENT_REMOVAL_PREFIX = "!";
    private final Gson gson;
    private final boolean emitDefaultQuantity;
    private final JSONOptions.ShowItemHoverDataMode itemDataMode;

    static TypeAdapter<HoverEvent.ShowItem> create(Gson gson, OptionState optionState) {
        return new ShowItemSerializer(gson, optionState.value(JSONOptions.EMIT_DEFAULT_ITEM_HOVER_QUANTITY), optionState.value(JSONOptions.SHOW_ITEM_HOVER_DATA_MODE)).nullSafe();
    }

    private ShowItemSerializer(Gson gson, boolean bl, JSONOptions.ShowItemHoverDataMode showItemHoverDataMode) {
        this.gson = gson;
        this.emitDefaultQuantity = bl;
        this.itemDataMode = showItemHoverDataMode;
    }

    public final HoverEvent.ShowItem read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Key key = null;
        int n2 = 1;
        BinaryTagHolder binaryTagHolder = null;
        HashMap<Object, DataComponentValue.Removed> hashMap = null;
        while (jsonReader.hasNext()) {
            Object object = jsonReader.nextName();
            if (((String)object).equals("id")) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (((String)object).equals("count")) {
                n2 = jsonReader.nextInt();
                continue;
            }
            if (((String)object).equals(LEGACY_SHOW_ITEM_TAG)) {
                object = jsonReader.peek();
                if (object == JsonToken.STRING || object == JsonToken.NUMBER) {
                    binaryTagHolder = BinaryTagHolder.binaryTagHolder(jsonReader.nextString());
                    continue;
                }
                if (object == JsonToken.BOOLEAN) {
                    binaryTagHolder = BinaryTagHolder.binaryTagHolder(String.valueOf(jsonReader.nextBoolean()));
                    continue;
                }
                if (object == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                throw new JsonParseException("Expected tag to be a string");
            }
            if (((String)object).equals("components")) {
                jsonReader.beginObject();
                while (jsonReader.peek() != JsonToken.END_OBJECT) {
                    boolean bl;
                    object = jsonReader.nextName();
                    if (((String)object).startsWith(DATA_COMPONENT_REMOVAL_PREFIX)) {
                        object = Key.key(((String)object).substring(1));
                        bl = true;
                    } else {
                        object = Key.key((String)object);
                        bl = false;
                    }
                    JsonElement jsonElement = (JsonElement)this.gson.fromJson(jsonReader, JsonElement.class);
                    if (hashMap == null) {
                        hashMap = new HashMap<Object, DataComponentValue.Removed>();
                    }
                    hashMap.put(object, (DataComponentValue.Removed)(bl ? DataComponentValue.removed() : GsonDataComponentValue.gsonDataComponentValue(jsonElement)));
                }
                jsonReader.endObject();
                continue;
            }
            jsonReader.skipValue();
        }
        if (key == null) {
            throw new JsonParseException("Not sure how to deserialize show_item hover event");
        }
        jsonReader.endObject();
        if (hashMap != null) {
            return HoverEvent.ShowItem.showItem(key, n2, hashMap);
        }
        return HoverEvent.ShowItem.showItem(key, n2, binaryTagHolder);
    }

    public final void write(JsonWriter jsonWriter, HoverEvent.ShowItem object) {
        Map<Key, DataComponentValue> object22;
        jsonWriter.beginObject();
        jsonWriter.name("id");
        this.gson.toJson((Object)((HoverEvent.ShowItem)((Object)object)).item(), SerializerFactory.KEY_TYPE, jsonWriter);
        int n2 = ((HoverEvent.ShowItem)((Object)object)).count();
        if (n2 != 1 || this.emitDefaultQuantity) {
            jsonWriter.name("count");
            jsonWriter.value((long)n2);
        }
        if (!(object22 = ((HoverEvent.ShowItem)((Object)object)).dataComponents()).isEmpty() && this.itemDataMode != JSONOptions.ShowItemHoverDataMode.EMIT_LEGACY_NBT) {
            jsonWriter.name("components");
            jsonWriter.beginObject();
            for (Map.Entry<Key, GsonDataComponentValue> entry : ((HoverEvent.ShowItem)((Object)object)).dataComponentsAs(GsonDataComponentValue.class).entrySet()) {
                JsonElement jsonElement = entry.getValue().element();
                if (jsonElement instanceof JsonNull) {
                    jsonWriter.name(DATA_COMPONENT_REMOVAL_PREFIX + entry.getKey().asString());
                    jsonWriter.beginObject().endObject();
                    continue;
                }
                jsonWriter.name(entry.getKey().asString());
                this.gson.toJson(jsonElement, jsonWriter);
            }
            jsonWriter.endObject();
        } else if (this.itemDataMode != JSONOptions.ShowItemHoverDataMode.EMIT_DATA_COMPONENTS) {
            ShowItemSerializer.maybeWriteLegacy(jsonWriter, (HoverEvent.ShowItem)((Object)object));
        }
        jsonWriter.endObject();
    }

    private static void maybeWriteLegacy(JsonWriter jsonWriter, HoverEvent.ShowItem examinable) {
        if ((examinable = ((HoverEvent.ShowItem)examinable).nbt()) != null) {
            jsonWriter.name(LEGACY_SHOW_ITEM_TAG);
            jsonWriter.value(examinable.string());
        }
    }
}

