/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.UUID;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.BlockNBTComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TranslationArgument;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.ClickEvent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.ShadowColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextDecoration;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.BlockNBTComponentPosSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.ClickEventActionSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.HoverEventActionSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.KeySerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.ShadowColorSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.ShowEntitySerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.ShowItemSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.StyleSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.TextColorSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.TextColorWrapper;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.TextDecorationSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.TranslationArgumentSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.UUIDSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.LegacyHoverEventSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.option.OptionState;
import org.jetbrains.annotations.Nullable;

final class SerializerFactory
implements TypeAdapterFactory {
    static final Class<Key> KEY_TYPE = Key.class;
    static final Class<Component> COMPONENT_TYPE = Component.class;
    static final Class<Style> STYLE_TYPE = Style.class;
    static final Class<ClickEvent.Action> CLICK_ACTION_TYPE = ClickEvent.Action.class;
    static final Class<HoverEvent.Action> HOVER_ACTION_TYPE = HoverEvent.Action.class;
    static final Class<HoverEvent.ShowItem> SHOW_ITEM_TYPE = HoverEvent.ShowItem.class;
    static final Class<HoverEvent.ShowEntity> SHOW_ENTITY_TYPE = HoverEvent.ShowEntity.class;
    static final Class<String> STRING_TYPE = String.class;
    static final Class<TextColorWrapper> COLOR_WRAPPER_TYPE = TextColorWrapper.class;
    static final Class<TextColor> COLOR_TYPE = TextColor.class;
    static final Class<ShadowColor> SHADOW_COLOR_TYPE = ShadowColor.class;
    static final Class<TextDecoration> TEXT_DECORATION_TYPE = TextDecoration.class;
    static final Class<BlockNBTComponent.Pos> BLOCK_NBT_POS_TYPE = BlockNBTComponent.Pos.class;
    static final Class<UUID> UUID_TYPE = UUID.class;
    static final Class<TranslationArgument> TRANSLATION_ARGUMENT_TYPE = TranslationArgument.class;
    private final OptionState features;
    private final LegacyHoverEventSerializer legacyHoverSerializer;

    SerializerFactory(OptionState optionState, @Nullable LegacyHoverEventSerializer legacyHoverEventSerializer) {
        this.features = optionState;
        this.legacyHoverSerializer = legacyHoverEventSerializer;
    }

    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> object) {
        if (COMPONENT_TYPE.isAssignableFrom((Class<?>)(object = object.getRawType()))) {
            return ComponentSerializerImpl.create(this.features, gson);
        }
        if (KEY_TYPE.isAssignableFrom((Class<?>)object)) {
            return KeySerializer.INSTANCE;
        }
        if (STYLE_TYPE.isAssignableFrom((Class<?>)object)) {
            return StyleSerializer.create(this.legacyHoverSerializer, this.features, gson);
        }
        if (CLICK_ACTION_TYPE.isAssignableFrom((Class<?>)object)) {
            return ClickEventActionSerializer.INSTANCE;
        }
        if (HOVER_ACTION_TYPE.isAssignableFrom((Class<?>)object)) {
            return HoverEventActionSerializer.INSTANCE;
        }
        if (SHOW_ITEM_TYPE.isAssignableFrom((Class<?>)object)) {
            return ShowItemSerializer.create(gson, this.features);
        }
        if (SHOW_ENTITY_TYPE.isAssignableFrom((Class<?>)object)) {
            return ShowEntitySerializer.create(gson, this.features);
        }
        if (COLOR_WRAPPER_TYPE.isAssignableFrom((Class<?>)object)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (COLOR_TYPE.isAssignableFrom((Class<?>)object)) {
            if (this.features.value(JSONOptions.EMIT_RGB).booleanValue()) {
                return TextColorSerializer.INSTANCE;
            }
            return TextColorSerializer.DOWNSAMPLE_COLOR;
        }
        if (SHADOW_COLOR_TYPE.isAssignableFrom((Class<?>)object)) {
            return ShadowColorSerializer.create(this.features);
        }
        if (TEXT_DECORATION_TYPE.isAssignableFrom((Class<?>)object)) {
            return TextDecorationSerializer.INSTANCE;
        }
        if (BLOCK_NBT_POS_TYPE.isAssignableFrom((Class<?>)object)) {
            return BlockNBTComponentPosSerializer.INSTANCE;
        }
        if (UUID_TYPE.isAssignableFrom((Class<?>)object)) {
            return UUIDSerializer.uuidSerializer(this.features);
        }
        if (TRANSLATION_ARGUMENT_TYPE.isAssignableFrom((Class<?>)object)) {
            return TranslationArgumentSerializer.create(gson);
        }
        return null;
    }
}

