/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.GsonComponentSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.gson.SerializerFactory;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.serializer.json.LegacyHoverEventSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.Services;
import me.loving11ish.clientdetectorplus.libs.adventure.option.OptionState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    private static final Optional<GsonComponentSerializer.Provider> SERVICE = Services.service(GsonComponentSerializer.Provider.class);
    static final Consumer<GsonComponentSerializer.Builder> BUILDER = SERVICE.map(GsonComponentSerializer.Provider::builder).orElseGet(() -> builder -> {});
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
    private final OptionState flags;

    GsonComponentSerializerImpl(OptionState optionState, @Nullable LegacyHoverEventSerializer legacyHoverEventSerializer) {
        this.flags = optionState;
        this.legacyHoverSerializer = legacyHoverEventSerializer;
        this.populator = gsonBuilder -> {
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SerializerFactory(optionState, legacyHoverEventSerializer));
            return gsonBuilder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder().disableHtmlEscaping())).create();
    }

    @Override
    @NotNull
    public final Gson serializer() {
        return this.serializer;
    }

    @Override
    @NotNull
    public final UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    @NotNull
    public final Component deserialize(@NotNull String string) {
        Component component = (Component)this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(string);
        }
        return component;
    }

    @Override
    @Nullable
    public final Component deserializeOr(@Nullable String object, @Nullable Component component) {
        if (object == null) {
            return component;
        }
        object = (Component)this.serializer().fromJson((String)object, Component.class);
        if (object == null) {
            return component;
        }
        return object;
    }

    @Override
    @NotNull
    public final String serialize(@NotNull Component component) {
        return this.serializer().toJson((Object)component);
    }

    @Override
    @NotNull
    public final Component deserializeFromTree(@NotNull JsonElement jsonElement) {
        Component component = (Component)this.serializer().fromJson(jsonElement, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonElement);
        }
        return component;
    }

    @Override
    @NotNull
    public final JsonElement serializeToTree(@NotNull Component component) {
        return this.serializer().toJsonTree((Object)component);
    }

    @Override
    @NotNull
    public final GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private OptionState flags = JSONOptions.byDataVersion();
        private @Nullable LegacyHoverEventSerializer legacyHoverSerializer;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(GsonComponentSerializerImpl gsonComponentSerializerImpl) {
            this();
            this.flags = gsonComponentSerializerImpl.flags;
            this.legacyHoverSerializer = gsonComponentSerializerImpl.legacyHoverSerializer;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer.Builder options(@NotNull OptionState optionState) {
            this.flags = Objects.requireNonNull(optionState, "flags");
            return this;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer.Builder editOptions(@NotNull Consumer<OptionState.Builder> consumer) {
            OptionState.Builder builder = JSONOptions.schema().stateBuilder().values(this.flags);
            Objects.requireNonNull(consumer, "flagEditor").accept(builder);
            this.flags = builder.build();
            return this;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer) {
            this.legacyHoverSerializer = legacyHoverEventSerializer;
            return this;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer build() {
            return new GsonComponentSerializerImpl(this.flags, this.legacyHoverSerializer);
        }
    }

    static final class Instances {
        static final GsonComponentSerializer INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gson).orElseGet(() -> new GsonComponentSerializerImpl(JSONOptions.byDataVersion(), null));
        static final GsonComponentSerializer LEGACY_INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gsonLegacy).orElseGet(() -> new GsonComponentSerializerImpl(JSONOptions.byDataVersion().at(2525), null));

        Instances() {
        }
    }
}

