/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.standard;

import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.NamedTextColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.ShadowColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.StyleBuilderApplicable;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.StyleGetter;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.serializer.StyleClaim;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.standard.ColorTagResolver;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.RGBLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShadowColorTag {
    private static final String SHADOW_COLOR = "shadow";
    private static final String SHADOW_NONE = "!shadow";
    private static final float DEFAULT_ALPHA = 0.25f;
    static final TagResolver RESOLVER = TagResolver.resolver(SerializableResolver.claimingStyle("shadow", ShadowColorTag::create, StyleClaim.claim("shadow", StyleGetter::shadowColor, ShadowColorTag::emit)), TagResolver.resolver("!shadow", Tag.styling(ShadowColor.none())));

    static Tag create(@NotNull ArgumentQueue object, @NotNull Context context) {
        Object object2 = object.popOr("Expected to find a color parameter: #RRGGBBAA").lowerValue();
        if (((String)object2).startsWith("#") && ((String)object2).length() == 9) {
            object = ShadowColor.fromHexString((String)object2);
            if (object == null) {
                throw context.newException(String.format("Unable to parse a shadow color from '%s'. Please use #RRGGBBAA formatting.", object2));
            }
        } else {
            object2 = ColorTagResolver.resolveColor((String)object2, context);
            float f2 = object.hasNext() ? (float)object.pop().asDouble().orElseThrow(() -> context.newException("Number was expected to be a double")) : 0.25f;
            object = ShadowColor.shadowColor((RGBLike)object2, (int)(f2 * 255.0f));
        }
        return Tag.styling(new StyleBuilderApplicable[]{object});
    }

    static void emit(@NotNull ShadowColor shadowColor, @NotNull TokenEmitter tokenEmitter) {
        if (ShadowColor.none().equals(shadowColor)) {
            tokenEmitter.tag(SHADOW_NONE);
            return;
        }
        tokenEmitter.tag(SHADOW_COLOR);
        @Nullable NamedTextColor namedTextColor = NamedTextColor.namedColor(TextColor.color(shadowColor).value());
        if (namedTextColor != null) {
            tokenEmitter.argument(NamedTextColor.NAMES.key(namedTextColor)).argument(Float.toString((float)shadowColor.alpha() / 255.0f));
            return;
        }
        tokenEmitter.argument(shadowColor.asHexString());
    }

    private ShadowColorTag() {
    }
}

