/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.standard;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.HSVLike;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RainbowTag
extends AbstractColorChangingTag {
    private static final String REVERSE = "!";
    private static final String RAINBOW = "rainbow";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("rainbow", RainbowTag::create, AbstractColorChangingTag::claimComponent);
    private final boolean reversed;
    private final double dividedPhase;
    private int colorIndex = 0;

    static Tag create(ArgumentQueue object, Context context) {
        boolean bl = false;
        int n2 = 0;
        if (object.hasNext()) {
            if (((String)(object = object.pop().value())).startsWith(REVERSE)) {
                bl = true;
                object = ((String)object).substring(1);
            }
            if (((String)object).length() > 0) {
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw context.newException("Expected phase, got " + (String)object);
                }
            }
        }
        return new RainbowTag(bl, n2, context);
    }

    private RainbowTag(boolean bl, int n2, Context context) {
        super(context);
        this.reversed = bl;
        this.dividedPhase = (double)n2 / 10.0;
    }

    @Override
    protected final void init() {
        if (this.reversed) {
            this.colorIndex = this.size() - 1;
        }
    }

    @Override
    protected final void advanceColor() {
        if (this.reversed) {
            if (this.colorIndex == 0) {
                this.colorIndex = this.size() - 1;
                return;
            }
            --this.colorIndex;
            return;
        }
        ++this.colorIndex;
    }

    @Override
    protected final TextColor color() {
        float f2 = this.colorIndex;
        f2 = (float)(((double)(f2 / (float)this.size()) + this.dividedPhase) % 1.0);
        return TextColor.color(HSVLike.hsvLike(f2, 1.0f, 1.0f));
    }

    @Override
    @NotNull
    protected final Consumer<TokenEmitter> preserveData() {
        boolean bl = this.reversed;
        int n2 = (int)Math.round(this.dividedPhase * 10.0);
        return tokenEmitter -> {
            tokenEmitter.tag(RAINBOW);
            if (bl && n2 != 0) {
                tokenEmitter.argument(REVERSE + n2);
                return;
            }
            if (bl) {
                tokenEmitter.argument(REVERSE);
                return;
            }
            if (n2 != 0) {
                tokenEmitter.argument(Integer.toString(n2));
            }
        };
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.dividedPhase));
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (RainbowTag)object;
        return this.colorIndex == ((RainbowTag)object).colorIndex && this.dividedPhase == ((RainbowTag)object).dividedPhase;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.colorIndex, this.dividedPhase);
    }
}

