/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.ArgumentQueueImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.ContextImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.ParsingException;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.Token;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.TokenParser;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.TokenType;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.node.ElementNode;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.node.RootNode;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.node.TagNode;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.internal.parser.node.ValueNode;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.Inserting;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.Modifying;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.minimessage.tree.Node;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.Examinable;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.string.MultiLineStringExaminer;
import org.jetbrains.annotations.NotNull;

final class MiniMessageParser {
    final TagResolver tagResolver;

    MiniMessageParser() {
        this.tagResolver = TagResolver.standard();
    }

    MiniMessageParser(TagResolver tagResolver) {
        this.tagResolver = tagResolver;
    }

    @NotNull
    final String escapeTokens(@NotNull ContextImpl contextImpl) {
        StringBuilder stringBuilder = new StringBuilder(contextImpl.message().length());
        this.escapeTokens(stringBuilder, contextImpl);
        return stringBuilder.toString();
    }

    final void escapeTokens(StringBuilder stringBuilder, @NotNull ContextImpl contextImpl) {
        this.escapeTokens(stringBuilder, contextImpl.message(), contextImpl);
    }

    private void escapeTokens(StringBuilder stringBuilder2, String string, ContextImpl contextImpl) {
        this.processTokens(stringBuilder2, string, contextImpl, (object, stringBuilder) -> {
            stringBuilder.append('\\').append('<');
            if (((Token)object).type() == TokenType.CLOSE_TAG) {
                stringBuilder.append('/');
            }
            object = ((Token)object).childTokens();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                if (i2 != 0) {
                    stringBuilder.append(':');
                }
                this.escapeTokens((StringBuilder)stringBuilder, ((Token)object.get(i2)).get(string).toString(), contextImpl);
            }
            stringBuilder.append('>');
        });
    }

    @NotNull
    final String stripTokens(@NotNull ContextImpl contextImpl) {
        StringBuilder stringBuilder2 = new StringBuilder(contextImpl.message().length());
        this.processTokens(stringBuilder2, contextImpl, (token, stringBuilder) -> {});
        return stringBuilder2.toString();
    }

    private void processTokens(@NotNull StringBuilder stringBuilder, @NotNull ContextImpl contextImpl, BiConsumer<Token, StringBuilder> biConsumer) {
        this.processTokens(stringBuilder, contextImpl.message(), contextImpl, biConsumer);
    }

    private void processTokens(@NotNull StringBuilder stringBuilder, @NotNull String string, @NotNull ContextImpl object, BiConsumer<Token, StringBuilder> biConsumer) {
        object = TagResolver.resolver(this.tagResolver, ((ContextImpl)object).extraTags());
        Object object2 = TokenParser.tokenize(string, true);
        object2 = object2.iterator();
        block4: while (object2.hasNext()) {
            Token token = (Token)object2.next();
            switch (token.type()) {
                case TEXT: {
                    stringBuilder.append(string, token.startIndex(), token.endIndex());
                    continue block4;
                }
                case OPEN_TAG: 
                case CLOSE_TAG: 
                case OPEN_CLOSE_TAG: {
                    if (token.childTokens().isEmpty()) {
                        stringBuilder.append(string, token.startIndex(), token.endIndex());
                        continue block4;
                    }
                    String string2 = TokenParser.TagProvider.sanitizePlaceholderName(token.childTokens().get(0).get(string).toString());
                    if (object.has(string2)) {
                        biConsumer.accept(token, stringBuilder);
                        continue block4;
                    }
                    stringBuilder.append(string, token.startIndex(), token.endIndex());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported token type " + (Object)((Object)token.type()));
        }
    }

    @NotNull
    final RootNode parseToTree(@NotNull ContextImpl object) {
        Object object2 = TagResolver.resolver(this.tagResolver, ((ContextImpl)object).extraTags());
        String string = (String)((ContextImpl)object).preProcessor().apply(((ContextImpl)object).message());
        Consumer<String> consumer = ((ContextImpl)object).debugOutput();
        if (consumer != null) {
            consumer.accept("Beginning parsing message ");
            consumer.accept(string);
            consumer.accept("\n");
        }
        TokenParser.TagProvider tagProvider = consumer != null ? (arg_0, arg_1, arg_2) -> MiniMessageParser.lambda$parseToTree$2(consumer, (TagResolver)object2, (ContextImpl)object, arg_0, arg_1, arg_2) : (arg_0, arg_1, arg_2) -> MiniMessageParser.lambda$parseToTree$3((TagResolver)object2, (ContextImpl)object, arg_0, arg_1, arg_2);
        object2 = arg_0 -> MiniMessageParser.lambda$parseToTree$4((TagResolver)object2, arg_0);
        String string2 = TokenParser.resolvePreProcessTags(string, tagProvider);
        ((ContextImpl)object).message(string2);
        object = TokenParser.parse(tagProvider, (Predicate<String>)object2, string2, string, ((ContextImpl)object).strict());
        if (consumer != null) {
            consumer.accept("Text parsed into element tree:\n");
            consumer.accept(((ElementNode)object).toString());
        }
        return object;
    }

    @NotNull
    final Component parseFormat(@NotNull ContextImpl contextImpl) {
        RootNode rootNode = this.parseToTree(contextImpl);
        return Objects.requireNonNull((Component)contextImpl.postProcessor().apply(this.treeToComponent(rootNode, contextImpl)), "Post-processor must not return null");
    }

    @NotNull
    final Component treeToComponent(@NotNull ElementNode elementNode, @NotNull ContextImpl contextImpl) {
        Object object;
        Component component = Component.empty();
        Tag tag = null;
        if (elementNode instanceof ValueNode) {
            component = Component.text(((ValueNode)elementNode).value());
        } else if (elementNode instanceof TagNode) {
            object = (TagNode)elementNode;
            tag = ((TagNode)object).tag();
            if (tag instanceof Modifying) {
                Modifying modifying = (Modifying)tag;
                this.visitModifying(modifying, (ElementNode)object, 0);
                modifying.postVisit();
            }
            if (tag instanceof Inserting) {
                component = ((Inserting)tag).value();
            }
        }
        if (!elementNode.unsafeChildren().isEmpty()) {
            object = new ArrayList<Component>(component.children().size() + elementNode.children().size());
            object.addAll(component.children());
            for (ElementNode elementNode2 : elementNode.unsafeChildren()) {
                object.add(this.treeToComponent(elementNode2, contextImpl));
            }
            component = component.children((List<? extends ComponentLike>)object);
        }
        if (tag instanceof Modifying) {
            component = this.handleModifying((Modifying)tag, component, 0);
        }
        if ((object = contextImpl.debugOutput()) != null) {
            object.accept("==========\ntreeToComponent \n");
            object.accept((String)elementNode.toString());
            object.accept((String)"\n");
            object.accept((String)component.examine(MultiLineStringExaminer.simpleEscaping()).collect(Collectors.joining("\n")));
            object.accept((String)"\n==========\n");
        }
        return component;
    }

    private void visitModifying(Modifying modifying, ElementNode object, int n2) {
        modifying.visit((Node)object, n2);
        for (ElementNode elementNode : ((ElementNode)object).unsafeChildren()) {
            this.visitModifying(modifying, elementNode, n2 + 1);
        }
    }

    private Component handleModifying(Modifying modifying, Component object, int n2) {
        Component component = modifying.apply((Component)object, n2);
        for (Component component2 : object.children()) {
            component = component.append(this.handleModifying(modifying, component2, n2 + 1));
        }
        return component;
    }

    private static /* synthetic */ boolean lambda$parseToTree$4(TagResolver tagResolver, String string) {
        string = TokenParser.TagProvider.sanitizePlaceholderName(string);
        return tagResolver.has(string);
    }

    private static /* synthetic */ Tag lambda$parseToTree$3(TagResolver tagResolver, ContextImpl contextImpl, String string, List list, Token token) {
        try {
            return tagResolver.resolve(string, new ArgumentQueueImpl(contextImpl, list), contextImpl);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    private static /* synthetic */ Tag lambda$parseToTree$2(Consumer consumer, TagResolver object, ContextImpl object2, String string, List list, Token token) {
        try {
            consumer.accept("Attempting to match node '");
            consumer.accept(string);
            consumer.accept("'");
            if (token != null) {
                consumer.accept(" at column ");
                consumer.accept(String.valueOf(token.startIndex()));
            }
            consumer.accept("\n");
            object = object.resolve(string, new ArgumentQueueImpl((Context)object2, list), (Context)object2);
            if (object == null) {
                consumer.accept("Could not match node '");
                consumer.accept(string);
                consumer.accept("'\n");
            } else {
                consumer.accept("Successfully matched node '");
                consumer.accept(string);
                consumer.accept("' to tag ");
                consumer.accept(object instanceof Examinable ? ((Examinable)object).examinableName() : object.getClass().getName());
                consumer.accept("\n");
            }
            return object;
        }
        catch (ParsingException parsingException) {
            if (token != null && parsingException instanceof ParsingExceptionImpl && ((ParsingExceptionImpl)(object2 = (ParsingExceptionImpl)parsingException)).tokens().length == 0) {
                ((ParsingExceptionImpl)object2).tokens(new Token[]{token});
            }
            consumer.accept("Could not match node '");
            consumer.accept(string);
            consumer.accept("' - ");
            consumer.accept(parsingException.getMessage());
            consumer.accept("\n");
            return null;
        }
    }
}

