/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format;

import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.ShadowColorImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.StyleBuilderApplicable;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.ARGBLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.RGBLike;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface ShadowColor
extends StyleBuilderApplicable,
ARGBLike {
    @NotNull
    public static ShadowColor lerp(float f2, @NotNull ARGBLike aRGBLike, @NotNull ARGBLike aRGBLike2) {
        f2 = Math.min(1.0f, Math.max(0.0f, f2));
        int n2 = aRGBLike.red();
        int n3 = aRGBLike2.red();
        int n4 = aRGBLike.green();
        int n5 = aRGBLike2.green();
        int n6 = aRGBLike.blue();
        int n7 = aRGBLike2.blue();
        int n8 = aRGBLike.alpha();
        int n9 = aRGBLike2.alpha();
        return ShadowColor.shadowColor(Math.round((float)n2 + f2 * (float)(n3 - n2)), Math.round((float)n4 + f2 * (float)(n5 - n4)), Math.round((float)n6 + f2 * (float)(n7 - n6)), Math.round((float)n8 + f2 * (float)(n9 - n8)));
    }

    @NotNull
    public static ShadowColor none() {
        return ShadowColorImpl.NONE;
    }

    @Contract(pure=true)
    @NotNull
    public static ShadowColor shadowColor(int n2) {
        if (n2 == 0) {
            return ShadowColor.none();
        }
        return new ShadowColorImpl(n2);
    }

    @Contract(pure=true)
    @NotNull
    public static ShadowColor shadowColor(@Range(from=0L, to=255L) int n2, @Range(from=0L, to=255L) int n3, @Range(from=0L, to=255L) int n4, @Range(from=0L, to=255L) int n5) {
        if ((n2 = (n5 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF) == 0) {
            return ShadowColor.none();
        }
        return new ShadowColorImpl(n2);
    }

    @Contract(pure=true)
    @NotNull
    public static ShadowColor shadowColor(@NotNull RGBLike rGBLike, @Range(from=0L, to=255L) int n2) {
        return ShadowColor.shadowColor(rGBLike.red(), rGBLike.green(), rGBLike.blue(), n2);
    }

    @NotNull
    public static ShadowColor shadowColor(@NotNull ARGBLike aRGBLike) {
        if (aRGBLike instanceof ShadowColor) {
            return (ShadowColor)aRGBLike;
        }
        return ShadowColor.shadowColor(aRGBLike.red(), aRGBLike.green(), aRGBLike.blue(), aRGBLike.alpha());
    }

    @Contract(pure=true)
    @Nullable
    public static ShadowColor fromHexString(@Pattern(value="#[0-9a-fA-F]{8}") @NotNull String string) {
        if (string.length() != 9) {
            return null;
        }
        if (!string.startsWith("#")) {
            return null;
        }
        try {
            int n2 = Integer.parseInt(string.substring(1, 3), 16);
            int n3 = Integer.parseInt(string.substring(3, 5), 16);
            int n4 = Integer.parseInt(string.substring(5, 7), 16);
            int n5 = Integer.parseInt(string.substring(7, 9), 16);
            return new ShadowColorImpl(n5 << 24 | n2 << 16 | n3 << 8 | n4);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @NotNull
    default public String asHexString() {
        int n2 = this.value();
        int n3 = n2 >>> 24;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        return String.format("#%02X%02X%02X%02X", n4, n5, n2 &= 0xFF, n3);
    }

    @Override
    default public @Range(from=0L, to=255L) int red() {
        return this.value() >> 16 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int green() {
        return this.value() >> 8 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int blue() {
        return this.value() & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int alpha() {
        return this.value() >>> 24;
    }

    public int value();

    @Override
    default public void styleApply( @NotNull Style.Builder builder) {
        builder.shadowColor(this);
    }
}

