/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.flattener;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.KeybindComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ScoreComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.SelectorComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.TranslatableComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.flattener.ComponentFlattener;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.flattener.FlattenerListener;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.InheritanceAwareMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class ComponentFlattenerImpl
implements ComponentFlattener {
    static final ComponentFlattener BASIC = (ComponentFlattener)new BuilderImpl().mapper(KeybindComponent.class, keybindComponent -> keybindComponent.keybind()).mapper(ScoreComponent.class, object -> {
        if ((object = object.value()) != null) {
            return object;
        }
        return "";
    }).mapper(SelectorComponent.class, SelectorComponent::pattern).mapper(TextComponent.class, TextComponent::content).mapper(TranslatableComponent.class, translatableComponent -> {
        @Nullable String string = translatableComponent.fallback();
        if (string != null) {
            return string;
        }
        return translatableComponent.key();
    }).build();
    static final ComponentFlattener TEXT_ONLY = (ComponentFlattener)new BuilderImpl().mapper(TextComponent.class, TextComponent::content).build();
    private static final int MAX_DEPTH = 512;
    private final InheritanceAwareMap<Component, Handler> flatteners;
    private final Function<Component, String> unknownHandler;
    private final int maxNestedDepth;

    ComponentFlattenerImpl(InheritanceAwareMap<Component, Handler> inheritanceAwareMap, @Nullable Function<Component, String> function, int n2) {
        this.flatteners = inheritanceAwareMap;
        this.unknownHandler = function;
        this.maxNestedDepth = n2;
    }

    @Override
    public final void flatten(@NotNull Component component, @NotNull FlattenerListener flattenerListener) {
        this.flatten0(component, flattenerListener, 0, 0);
    }

    private void flatten0(@NotNull Component list, @NotNull FlattenerListener flattenerListener, int n2, int n3) {
        Objects.requireNonNull(list, "input");
        Objects.requireNonNull(flattenerListener, "listener");
        if (list == Component.empty()) {
            return;
        }
        if (this.maxNestedDepth != -1 && n3 > this.maxNestedDepth) {
            throw new IllegalStateException("Exceeded maximum nesting depth of " + this.maxNestedDepth + " while attempting to flatten components!");
        }
        ArrayDeque<StackEntry> arrayDeque = new ArrayDeque<StackEntry>();
        ArrayDeque<Style> arrayDeque2 = new ArrayDeque<Style>();
        arrayDeque.push(new StackEntry((Component)((Object)list), n2));
        while (!arrayDeque.isEmpty()) {
            list = (StackEntry)arrayDeque.pop();
            n2 = ((StackEntry)((Object)list)).depth;
            if (n2 > 512) {
                throw new IllegalStateException("Exceeded maximum depth of 512 while attempting to flatten components!");
            }
            list = ((StackEntry)((Object)list)).component;
            @Nullable Handler handler = this.flattener((Component)((Object)list));
            Style style = list.style();
            flattenerListener.pushStyle(style);
            arrayDeque2.push(style);
            if (handler != null) {
                handler.handle(this, (Component)((Object)list), flattenerListener, n2, n3);
            }
            if (!list.children().isEmpty() && flattenerListener.shouldContinue()) {
                list = list.children();
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    arrayDeque.push(new StackEntry(list.get(i2), n2 + 1));
                }
                continue;
            }
            list = (Style)arrayDeque2.pop();
            flattenerListener.popStyle((Style)((Object)list));
        }
        while (!arrayDeque2.isEmpty()) {
            list = (Style)arrayDeque2.pop();
            flattenerListener.popStyle((Style)((Object)list));
        }
    }

    @Nullable
    private <T extends Component> Handler flattener(T object) {
        if ((object = this.flatteners.get(object.getClass())) == null && this.unknownHandler != null) {
            return (componentFlattenerImpl, component, flattenerListener, n2, n3) -> flattenerListener.component(this.unknownHandler.apply(component));
        }
        return object;
    }

    @Override
    public final @NotNull ComponentFlattener.Builder toBuilder() {
        return new BuilderImpl(this.flatteners, this.unknownHandler, this.maxNestedDepth);
    }

    private static final class StackEntry {
        final Component component;
        final int depth;

        StackEntry(Component component, int n2) {
            this.component = component;
            this.depth = n2;
        }
    }

    @FunctionalInterface
    static interface Handler {
        public void handle(ComponentFlattenerImpl var1, Component var2, FlattenerListener var3, int var4, int var5);
    }

    static final class BuilderImpl
    implements ComponentFlattener.Builder {
        private final InheritanceAwareMap.Builder<Component, Handler> flatteners;
        @Nullable
        private Function<Component, String> unknownHandler;
        private int maxNestedDepth = -1;

        BuilderImpl() {
            this.flatteners = InheritanceAwareMap.builder().strict(true);
        }

        BuilderImpl(InheritanceAwareMap<Component, Handler> inheritanceAwareMap, @Nullable Function<Component, String> function, int n2) {
            this.flatteners = InheritanceAwareMap.builder(inheritanceAwareMap).strict(true);
            this.unknownHandler = function;
            this.maxNestedDepth = n2;
        }

        @Override
        @NotNull
        public final ComponentFlattener build() {
            return new ComponentFlattenerImpl((InheritanceAwareMap)this.flatteners.build(), this.unknownHandler, this.maxNestedDepth);
        }

        @Override
        public final <T extends Component> @NotNull ComponentFlattener.Builder mapper(@NotNull Class<T> clazz, @NotNull Function<T, String> function) {
            this.flatteners.put(clazz, (componentFlattenerImpl, component, flattenerListener, n2, n3) -> flattenerListener.component((String)function.apply(component)));
            return this;
        }

        @Override
        public final <T extends Component> @NotNull ComponentFlattener.Builder complexMapper(@NotNull Class<T> clazz, @NotNull BiConsumer<T, Consumer<Component>> biConsumer) {
            this.flatteners.put(clazz, (componentFlattenerImpl, component2, flattenerListener, n2, n3) -> biConsumer.accept(component2, component -> componentFlattenerImpl.flatten0(component, flattenerListener, n2, n3 + 1)));
            return this;
        }

        @Override
        public final @NotNull ComponentFlattener.Builder unknownMapper(@Nullable Function<Component, String> function) {
            this.unknownHandler = function;
            return this;
        }

        @Override
        @NotNull
        public final ComponentFlattener.Builder nestingLimit(@Range(from=1L, to=0x7FFFFFFFL) int n2) {
            if (n2 != -1 && n2 <= 0) {
                throw new IllegalArgumentException("limit must be positive or ComponentFlattener.NO_NESTING_LIMIT");
            }
            this.maxNestedDepth = n2;
            return this;
        }
    }
}

