/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Keyed;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.api.BinaryTagHolder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.DataComponentValue;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.DataComponentValueConverterRegistry;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.HoverEventSource;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.StyleBuilderApplicable;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.renderer.ComponentRenderer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.Index;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.Examinable;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class HoverEvent<V>
implements HoverEventSource<V>,
StyleBuilderApplicable,
Examinable {
    private final Action<V> action;
    private final V value;

    @NotNull
    public static HoverEvent<Component> showText(@NotNull ComponentLike componentLike) {
        return HoverEvent.showText(componentLike.asComponent());
    }

    @NotNull
    public static HoverEvent<Component> showText(@NotNull Component component) {
        return new HoverEvent<Component>(Action.SHOW_TEXT, component);
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return HoverEvent.showItem((Keyed)key, n2, Collections.emptyMap());
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return HoverEvent.showItem(keyed, n2, Collections.emptyMap());
    }

    @Deprecated
    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder) {
        return HoverEvent.showItem(ShowItem.showItem(key, n2, binaryTagHolder));
    }

    @Deprecated
    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder) {
        return HoverEvent.showItem(ShowItem.showItem(keyed, n2, binaryTagHolder));
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2, @NotNull Map<Key, ? extends DataComponentValue> map) {
        return HoverEvent.showItem(ShowItem.showItem(keyed, n2, map));
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull ShowItem showItem) {
        return new HoverEvent<ShowItem>(Action.SHOW_ITEM, showItem);
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Key key, @NotNull UUID uUID) {
        return HoverEvent.showEntity(key, uUID, null);
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Keyed keyed, @NotNull UUID uUID) {
        return HoverEvent.showEntity(keyed, uUID, null);
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Key key, @NotNull UUID uUID, @Nullable Component component) {
        return HoverEvent.showEntity(ShowEntity.of(key, uUID, component));
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Keyed keyed, @NotNull UUID uUID, @Nullable Component component) {
        return HoverEvent.showEntity(ShowEntity.of(keyed, uUID, component));
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull ShowEntity showEntity) {
        return new HoverEvent<ShowEntity>(Action.SHOW_ENTITY, showEntity);
    }

    @Deprecated
    @NotNull
    public static HoverEvent<String> showAchievement(@NotNull String string) {
        return new HoverEvent<String>(Action.SHOW_ACHIEVEMENT, string);
    }

    @NotNull
    public static <V> HoverEvent<V> hoverEvent(@NotNull Action<V> action, @NotNull V v2) {
        return new HoverEvent<V>(action, v2);
    }

    private HoverEvent(@NotNull Action<V> action, @NotNull V v2) {
        this.action = Objects.requireNonNull(action, "action");
        this.value = Objects.requireNonNull(v2, "value");
    }

    @NotNull
    public final Action<V> action() {
        return this.action;
    }

    @NotNull
    public final V value() {
        return this.value;
    }

    @NotNull
    public final HoverEvent<V> value(@NotNull V v2) {
        return new HoverEvent<V>(this.action, v2);
    }

    @NotNull
    public final <C> HoverEvent<V> withRenderedValue(@NotNull ComponentRenderer<C> componentRenderer, @NotNull C c2) {
        V v2 = this.value;
        componentRenderer = ((Action)this.action).renderer.render(componentRenderer, c2, v2);
        if (componentRenderer != v2) {
            return new HoverEvent<ComponentRenderer<C>>(this.action, componentRenderer);
        }
        return this;
    }

    @Override
    @NotNull
    public final HoverEvent<V> asHoverEvent() {
        return this;
    }

    @Override
    @NotNull
    public final HoverEvent<V> asHoverEvent(@NotNull UnaryOperator<V> unaryOperator) {
        if (unaryOperator == UnaryOperator.identity()) {
            return this;
        }
        return new HoverEvent<V>(this.action, unaryOperator.apply(this.value));
    }

    @Override
    public final void styleApply( @NotNull Style.Builder builder) {
        builder.hoverEvent((HoverEventSource)this);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (HoverEvent)object;
        return this.action == ((HoverEvent)object).action && this.value.equals(((HoverEvent)object).value);
    }

    public final int hashCode() {
        int n2 = this.action.hashCode();
        n2 = n2 * 31 + this.value.hashCode();
        return n2;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    public static final class Action<V> {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", Component.class, true, new Renderer<Component>(){

            @Override
            @NotNull
            public <C> Component render(@NotNull ComponentRenderer<C> componentRenderer, @NotNull C c2, @NotNull Component component) {
                return componentRenderer.render(component, c2);
            }
        });
        public static final Action<ShowItem> SHOW_ITEM = new Action<ShowItem>("show_item", ShowItem.class, true, new Renderer<ShowItem>(){

            @Override
            @NotNull
            public <C> ShowItem render(@NotNull ComponentRenderer<C> componentRenderer, @NotNull C c2, @NotNull ShowItem showItem) {
                return showItem;
            }
        });
        public static final Action<ShowEntity> SHOW_ENTITY = new Action<ShowEntity>("show_entity", ShowEntity.class, true, new Renderer<ShowEntity>(){

            @Override
            @NotNull
            public <C> ShowEntity render(@NotNull ComponentRenderer<C> componentRenderer, @NotNull C c2, @NotNull ShowEntity showEntity) {
                if (showEntity.name == null) {
                    return showEntity;
                }
                return showEntity.name(componentRenderer.render(showEntity.name, c2));
            }
        });
        @Deprecated
        public static final Action<String> SHOW_ACHIEVEMENT = new Action<String>("show_achievement", String.class, true, new Renderer<String>(){

            @Override
            @NotNull
            public <C> String render(@NotNull ComponentRenderer<C> componentRenderer, @NotNull C c2, @NotNull String string) {
                return string;
            }
        });
        public static final Index<String, Action<?>> NAMES = Index.create(action -> action.name, SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY, SHOW_ACHIEVEMENT);
        private final String name;
        private final Class<V> type;
        private final boolean readable;
        private final Renderer<V> renderer;

        Action(String string, Class<V> clazz, boolean bl, Renderer<V> renderer) {
            this.name = string;
            this.type = clazz;
            this.readable = bl;
            this.renderer = renderer;
        }

        @NotNull
        public final Class<V> type() {
            return this.type;
        }

        public final boolean readable() {
            return this.readable;
        }

        @NotNull
        public final String toString() {
            return this.name;
        }

        @FunctionalInterface
        static interface Renderer<V> {
            @NotNull
            public <C> V render(@NotNull ComponentRenderer<C> var1, @NotNull C var2, @NotNull V var3);
        }
    }

    public static final class ShowItem
    implements Examinable {
        private final Key item;
        private final int count;
        @Nullable
        private final BinaryTagHolder nbt;
        private final Map<Key, DataComponentValue> dataComponents;

        @NotNull
        public static ShowItem showItem(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2) {
            return ShowItem.showItem((Keyed)key, n2, Collections.emptyMap());
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowItem of(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2) {
            return ShowItem.showItem((Keyed)key, n2, Collections.emptyMap());
        }

        @NotNull
        public static ShowItem showItem(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2) {
            return ShowItem.showItem(keyed, n2, Collections.emptyMap());
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowItem of(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2) {
            return ShowItem.of(keyed, n2, null);
        }

        @Deprecated
        @NotNull
        public static ShowItem showItem(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder) {
            return new ShowItem(Objects.requireNonNull(key, "item"), n2, binaryTagHolder, Collections.emptyMap());
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowItem of(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder) {
            return new ShowItem(Objects.requireNonNull(key, "item"), n2, binaryTagHolder, Collections.emptyMap());
        }

        @Deprecated
        @NotNull
        public static ShowItem showItem(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder) {
            return new ShowItem(Objects.requireNonNull(keyed, "item").key(), n2, binaryTagHolder, Collections.emptyMap());
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowItem of(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder) {
            return new ShowItem(Objects.requireNonNull(keyed, "item").key(), n2, binaryTagHolder, Collections.emptyMap());
        }

        @NotNull
        public static ShowItem showItem(@NotNull Keyed keyed, @Range(from=0L, to=0x7FFFFFFFL) int n2, @NotNull Map<Key, ? extends DataComponentValue> map) {
            return new ShowItem(Objects.requireNonNull(keyed, "item").key(), n2, null, map);
        }

        private ShowItem(@NotNull Key key, @Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagHolder binaryTagHolder, @NotNull Map<Key, ? extends DataComponentValue> map) {
            this.item = key;
            this.count = n2;
            this.nbt = binaryTagHolder;
            this.dataComponents = Collections.unmodifiableMap(new HashMap<Key, DataComponentValue>(map));
        }

        @NotNull
        public final Key item() {
            return this.item;
        }

        @NotNull
        public final ShowItem item(@NotNull Key key) {
            if (Objects.requireNonNull(key, "item").equals(this.item)) {
                return this;
            }
            return new ShowItem(key, this.count, this.nbt, this.dataComponents);
        }

        public final @Range(from=0L, to=0x7FFFFFFFL) int count() {
            return this.count;
        }

        @NotNull
        public final ShowItem count(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
            if (n2 == this.count) {
                return this;
            }
            return new ShowItem(this.item, n2, this.nbt, this.dataComponents);
        }

        @Deprecated
        @Nullable
        public final BinaryTagHolder nbt() {
            return this.nbt;
        }

        @Deprecated
        @NotNull
        public final ShowItem nbt(@Nullable BinaryTagHolder binaryTagHolder) {
            if (Objects.equals(binaryTagHolder, this.nbt)) {
                return this;
            }
            return new ShowItem(this.item, this.count, binaryTagHolder, Collections.emptyMap());
        }

        @NotNull
        public final Map<Key, DataComponentValue> dataComponents() {
            return this.dataComponents;
        }

        @NotNull
        public final ShowItem dataComponents(@NotNull Map<Key, DataComponentValue> map) {
            if (Objects.equals(this.dataComponents, map)) {
                return this;
            }
            return new ShowItem(this.item, this.count, null, map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<Key, DataComponentValue>(map)));
        }

        @NotNull
        public final <V extends DataComponentValue> Map<Key, V> dataComponentsAs(@NotNull Class<V> clazz) {
            if (this.dataComponents.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<Key, V> hashMap = new HashMap<Key, V>(this.dataComponents.size());
            for (Map.Entry<Key, DataComponentValue> entry : this.dataComponents.entrySet()) {
                hashMap.put(entry.getKey(), DataComponentValueConverterRegistry.convert(clazz, entry.getKey(), entry.getValue()));
            }
            return Collections.unmodifiableMap(hashMap);
        }

        public final boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (ShowItem)object;
            return this.item.equals(((ShowItem)object).item) && this.count == ((ShowItem)object).count && Objects.equals(this.nbt, ((ShowItem)object).nbt) && Objects.equals(this.dataComponents, ((ShowItem)object).dataComponents);
        }

        public final int hashCode() {
            int n2 = this.item.hashCode();
            n2 = n2 * 31 + Integer.hashCode(this.count);
            n2 = n2 * 31 + Objects.hashCode(this.nbt);
            n2 = n2 * 31 + Objects.hashCode(this.dataComponents);
            return n2;
        }

        @Override
        @NotNull
        public final Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("item", this.item), ExaminableProperty.of("count", this.count), ExaminableProperty.of("nbt", this.nbt), ExaminableProperty.of("dataComponents", this.dataComponents));
        }

        public final String toString() {
            return Internals.toString(this);
        }
    }

    public static final class ShowEntity
    implements Examinable {
        private final Key type;
        private final UUID id;
        private final Component name;

        @NotNull
        public static ShowEntity showEntity(@NotNull Key key, @NotNull UUID uUID) {
            return ShowEntity.showEntity(key, uUID, null);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowEntity of(@NotNull Key key, @NotNull UUID uUID) {
            return ShowEntity.of(key, uUID, null);
        }

        @NotNull
        public static ShowEntity showEntity(@NotNull Keyed keyed, @NotNull UUID uUID) {
            return ShowEntity.showEntity(keyed, uUID, null);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowEntity of(@NotNull Keyed keyed, @NotNull UUID uUID) {
            return ShowEntity.of(keyed, uUID, null);
        }

        @NotNull
        public static ShowEntity showEntity(@NotNull Key key, @NotNull UUID uUID, @Nullable Component component) {
            return new ShowEntity(Objects.requireNonNull(key, "type"), Objects.requireNonNull(uUID, "id"), component);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowEntity of(@NotNull Key key, @NotNull UUID uUID, @Nullable Component component) {
            return new ShowEntity(Objects.requireNonNull(key, "type"), Objects.requireNonNull(uUID, "id"), component);
        }

        @NotNull
        public static ShowEntity showEntity(@NotNull Keyed keyed, @NotNull UUID uUID, @Nullable Component component) {
            return new ShowEntity(Objects.requireNonNull(keyed, "type").key(), Objects.requireNonNull(uUID, "id"), component);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static ShowEntity of(@NotNull Keyed keyed, @NotNull UUID uUID, @Nullable Component component) {
            return new ShowEntity(Objects.requireNonNull(keyed, "type").key(), Objects.requireNonNull(uUID, "id"), component);
        }

        private ShowEntity(@NotNull Key key, @NotNull UUID uUID, @Nullable Component component) {
            this.type = key;
            this.id = uUID;
            this.name = component;
        }

        @NotNull
        public final Key type() {
            return this.type;
        }

        @NotNull
        public final ShowEntity type(@NotNull Key key) {
            if (Objects.requireNonNull(key, "type").equals(this.type)) {
                return this;
            }
            return new ShowEntity(key, this.id, this.name);
        }

        @NotNull
        public final ShowEntity type(@NotNull Keyed keyed) {
            return this.type(Objects.requireNonNull(keyed, "type").key());
        }

        @NotNull
        public final UUID id() {
            return this.id;
        }

        @NotNull
        public final ShowEntity id(@NotNull UUID uUID) {
            if (Objects.requireNonNull(uUID).equals(this.id)) {
                return this;
            }
            return new ShowEntity(this.type, uUID, this.name);
        }

        @Nullable
        public final Component name() {
            return this.name;
        }

        @NotNull
        public final ShowEntity name(@Nullable Component component) {
            if (Objects.equals(component, this.name)) {
                return this;
            }
            return new ShowEntity(this.type, this.id, component);
        }

        public final boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (ShowEntity)object;
            return this.type.equals(((ShowEntity)object).type) && this.id.equals(((ShowEntity)object).id) && Objects.equals(this.name, ((ShowEntity)object).name);
        }

        public final int hashCode() {
            int n2 = this.type.hashCode();
            n2 = n2 * 31 + this.id.hashCode();
            n2 = n2 * 31 + Objects.hashCode(this.name);
            return n2;
        }

        @Override
        @NotNull
        public final Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("type", this.type), ExaminableProperty.of("id", this.id), ExaminableProperty.of("name", this.name));
        }

        public final String toString() {
            return Internals.toString(this);
        }
    }
}

