/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.DataComponentValue;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.DataComponentValueConversionImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.Services;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataComponentValueConverterRegistry {
    private static final Set<Provider> PROVIDERS = Services.services(Provider.class);

    private DataComponentValueConverterRegistry() {
    }

    public static Set<Key> knownProviders() {
        return Collections.unmodifiableSet(PROVIDERS.stream().map(Provider::id).collect(Collectors.toSet()));
    }

    @NotNull
    public static <O extends DataComponentValue> O convert(@NotNull Class<O> clazz, @NotNull Key key, @NotNull DataComponentValue dataComponentValue) {
        if (clazz.isInstance(dataComponentValue)) {
            return (O)((DataComponentValue)clazz.cast(dataComponentValue));
        }
        @Nullable RegisteredConversion registeredConversion = ConversionCache.converter(dataComponentValue.getClass(), clazz);
        if (registeredConversion == null) {
            throw new IllegalArgumentException("There is no data holder converter registered to convert from a " + dataComponentValue.getClass() + " instance to a " + clazz + " (on field " + key + ")");
        }
        try {
            return (O)((DataComponentValue)registeredConversion.conversion.convert(key, dataComponentValue));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to convert data component value of type " + dataComponentValue.getClass() + " to type " + clazz + " due to an error in a converter provided by " + registeredConversion.provider.asString() + "!", exception);
        }
    }

    static final class ConversionCache {
        private static final ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, RegisteredConversion>> CACHE = new ConcurrentHashMap();
        private static final Map<Class<?>, Set<RegisteredConversion>> CONVERSIONS = ConversionCache.collectConversions();

        ConversionCache() {
        }

        private static Map<Class<?>, Set<RegisteredConversion>> collectConversions() {
            ConcurrentHashMap<Class, Set> concurrentHashMap = new ConcurrentHashMap<Class, Set>();
            for (Provider provider : PROVIDERS) {
                @NotNull Key key = Objects.requireNonNull(provider.id(), () -> "ID of provider " + provider + " is null");
                for (Conversion<?, ?> conversion : provider.conversions()) {
                    concurrentHashMap.computeIfAbsent(conversion.source(), clazz -> ConcurrentHashMap.newKeySet()).add(new RegisteredConversion(key, conversion));
                }
            }
            for (Map.Entry entry : concurrentHashMap.entrySet()) {
                entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
            }
            return new ConcurrentHashMap(concurrentHashMap);
        }

        static RegisteredConversion compute(Class<?> clazz, Class<?> clazz2) {
            ArrayDeque arrayDeque = new ArrayDeque();
            arrayDeque.add(clazz);
            while ((clazz = (Class)arrayDeque.poll()) != null) {
                Set<RegisteredConversion> set = CONVERSIONS.get(clazz);
                if (set != null) {
                    RegisteredConversion registeredConversion = null;
                    for (RegisteredConversion registeredConversion2 : set) {
                        Class<?> clazz3 = registeredConversion2.conversion.destination();
                        if (clazz2.equals(clazz3)) {
                            return registeredConversion2;
                        }
                        if (!clazz2.isAssignableFrom(clazz3) || registeredConversion != null && !clazz3.isAssignableFrom(registeredConversion.conversion.destination())) continue;
                        registeredConversion = registeredConversion2;
                    }
                    if (registeredConversion != null) {
                        return registeredConversion;
                    }
                }
                ConversionCache.addSupertypes(clazz, arrayDeque);
            }
            return RegisteredConversion.NONE;
        }

        private static void addSupertypes(Class<?> clazz, Deque<Class<?>> deque) {
            if (clazz.getSuperclass() != null) {
                deque.add(clazz.getSuperclass());
            }
            deque.addAll(Arrays.asList(clazz.getInterfaces()));
        }

        @Nullable
        static RegisteredConversion converter(Class<? extends DataComponentValue> object, Class<? extends DataComponentValue> clazz2) {
            if ((object = CACHE.computeIfAbsent((Class<?>)object, (Function<Class<?>, ConcurrentMap<Class<?>, RegisteredConversion>>)((Function<Class, ConcurrentMap>)clazz -> new ConcurrentHashMap())).computeIfAbsent(clazz2, clazz3 -> ConversionCache.compute(object, clazz2))) == RegisteredConversion.NONE) {
                return null;
            }
            return object;
        }
    }

    static final class RegisteredConversion {
        static final RegisteredConversion NONE = new RegisteredConversion(null, null);
        final Key provider;
        final Conversion<?, ?> conversion;

        RegisteredConversion(Key key, Conversion<?, ?> conversion) {
            this.provider = key;
            this.conversion = conversion;
        }
    }

    @ApiStatus.NonExtendable
    public static interface Conversion<I, O>
    extends Examinable {
        @NotNull
        public static <I1, O1> Conversion<I1, O1> convert(@NotNull Class<I1> clazz, @NotNull Class<O1> clazz2, @NotNull BiFunction<Key, I1, O1> biFunction) {
            return new DataComponentValueConversionImpl<I1, O1>(Objects.requireNonNull(clazz, "src"), Objects.requireNonNull(clazz2, "dst"), Objects.requireNonNull(biFunction, "op"));
        }

        @Contract(pure=true)
        @NotNull
        public Class<I> source();

        @Contract(pure=true)
        @NotNull
        public Class<O> destination();

        @NotNull
        public O convert(@NotNull Key var1, @NotNull I var2);
    }

    public static interface Provider {
        @NotNull
        public Key id();

        @NotNull
        public Iterable<Conversion<?, ?>> conversions();
    }
}

