/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text;

import java.util.List;
import java.util.Objects;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.AbstractComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.AbstractComponentBuilder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.SelectorComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectorComponentImpl
extends AbstractComponent
implements SelectorComponent {
    private final String pattern;
    @Nullable
    private final Component separator;

    static SelectorComponent create(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull String string, @Nullable ComponentLike componentLike) {
        return new SelectorComponentImpl(ComponentLike.asComponents(list, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(string, "pattern"), ComponentLike.unbox(componentLike));
    }

    SelectorComponentImpl(@NotNull List<Component> list, @NotNull Style style, @NotNull String string, @Nullable Component component) {
        super(list, style);
        this.pattern = string;
        this.separator = component;
    }

    @Override
    @NotNull
    public final String pattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public final SelectorComponent pattern(@NotNull String string) {
        if (Objects.equals(this.pattern, string)) {
            return this;
        }
        return SelectorComponentImpl.create(this.children, this.style, string, this.separator);
    }

    @Override
    @Nullable
    public final Component separator() {
        return this.separator;
    }

    @Override
    @NotNull
    public final SelectorComponent separator(@Nullable ComponentLike componentLike) {
        return SelectorComponentImpl.create(this.children, this.style, this.pattern, componentLike);
    }

    @Override
    @NotNull
    public final SelectorComponent children(@NotNull List<? extends ComponentLike> list) {
        return SelectorComponentImpl.create(list, this.style, this.pattern, this.separator);
    }

    @Override
    @NotNull
    public final SelectorComponent style(@NotNull Style style) {
        return SelectorComponentImpl.create(this.children, style, this.pattern, this.separator);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectorComponent)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        return Objects.equals(this.pattern, (object = (SelectorComponent)object).pattern()) && Objects.equals(this.separator, object.separator());
    }

    @Override
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + this.pattern.hashCode();
        n2 = n2 * 31 + Objects.hashCode(this.separator);
        return n2;
    }

    @Override
    public final String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public final SelectorComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<SelectorComponent, SelectorComponent.Builder>
    implements SelectorComponent.Builder {
        @Nullable
        private String pattern;
        @Nullable
        private Component separator;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull SelectorComponent selectorComponent) {
            super(selectorComponent);
            this.pattern = selectorComponent.pattern();
            this.separator = selectorComponent.separator();
        }

        @Override
        @NotNull
        public final SelectorComponent.Builder pattern(@NotNull String string) {
            this.pattern = Objects.requireNonNull(string, "pattern");
            return this;
        }

        @Override
        @NotNull
        public final SelectorComponent.Builder separator(@Nullable ComponentLike componentLike) {
            this.separator = ComponentLike.unbox(componentLike);
            return this;
        }

        @Override
        @NotNull
        public final SelectorComponent build() {
            if (this.pattern == null) {
                throw new IllegalStateException("pattern must be set");
            }
            return SelectorComponentImpl.create(this.children, this.buildStyle(), this.pattern, this.separator);
        }
    }
}

