/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ComponentLike {
    @NotNull
    public static List<Component> asComponents(@NotNull List<? extends ComponentLike> list) {
        return ComponentLike.asComponents(list, null);
    }

    @NotNull
    public static List<Component> asComponents(@NotNull List<? extends ComponentLike> list, @Nullable Predicate<? super Component> predicate) {
        Objects.requireNonNull(list, "likes");
        int n2 = list.size();
        if (n2 == 0) {
            return Collections.emptyList();
        }
        @Nullable ArrayList<ComponentLike> arrayList = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            @Nullable ComponentLike componentLike = list.get(i2);
            if (componentLike == null) {
                throw new NullPointerException("likes[" + i2 + "]");
            }
            componentLike = componentLike.asComponent();
            if (predicate != null && !predicate.test((Component)componentLike)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ComponentLike>(n2);
            }
            arrayList.add(componentLike);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    @Nullable
    public static Component unbox(@Nullable ComponentLike componentLike) {
        if (componentLike != null) {
            return componentLike.asComponent();
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public Component asComponent();
}

