/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.BuildableComponent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.Component;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ComponentBuilder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.ClickEvent;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.event.HoverEventSource;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.format.TextDecoration;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.ARGBLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractComponentBuilder<C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>>
implements ComponentBuilder<C, B> {
    protected List<Component> children = Collections.emptyList();
    @Nullable
    private Style style;
    private @Nullable Style.Builder styleBuilder;

    protected AbstractComponentBuilder() {
    }

    protected AbstractComponentBuilder(@NotNull C c2) {
        List<Component> list = c2.children();
        if (!list.isEmpty()) {
            this.children = new ArrayList<Component>(list);
        }
        if (c2.hasStyling()) {
            this.style = c2.style();
        }
    }

    @Override
    @NotNull
    public B append(@NotNull Component component) {
        if (component == Component.empty()) {
            return (B)this;
        }
        this.prepareChildren();
        this.children.add(Objects.requireNonNull(component, "component"));
        return (B)this;
    }

    @Override
    @NotNull
    public B append(Component ... componentArray) {
        return this.append((ComponentLike[])componentArray);
    }

    @Override
    @NotNull
    public B append(ComponentLike ... componentLikeArray) {
        Objects.requireNonNull(componentLikeArray, "components");
        boolean bl = false;
        int n2 = componentLikeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = Objects.requireNonNull(componentLikeArray[i2], "components[?]").asComponent();
            if (component == Component.empty()) continue;
            if (!bl) {
                this.prepareChildren();
                bl = true;
            }
            this.children.add(Objects.requireNonNull(component, "components[?]"));
        }
        return (B)this;
    }

    @Override
    @NotNull
    public B append(@NotNull Iterable<? extends ComponentLike> object) {
        Objects.requireNonNull(object, "components");
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            ComponentLike componentLike = (ComponentLike)object.next();
            if ((componentLike = Objects.requireNonNull(componentLike, "components[?]").asComponent()) == Component.empty()) continue;
            if (!bl) {
                this.prepareChildren();
                bl = true;
            }
            this.children.add((Component)Objects.requireNonNull(componentLike, "components[?]"));
        }
        return (B)this;
    }

    private void prepareChildren() {
        if (this.children == Collections.emptyList()) {
            this.children = new ArrayList<Component>();
        }
    }

    @Override
    @NotNull
    public B applyDeep(@NotNull Consumer<? super ComponentBuilder<?, ?>> consumer) {
        this.apply(consumer);
        if (this.children == Collections.emptyList()) {
            return (B)this;
        }
        ListIterator<Component> listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            Object object = listIterator.next();
            if (!(object instanceof BuildableComponent)) continue;
            object = ((BuildableComponent)object).toBuilder();
            object.applyDeep(consumer);
            listIterator.set((Component)object.build());
        }
        return (B)this;
    }

    @Override
    @NotNull
    public B mapChildren(@NotNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> function) {
        if (this.children == Collections.emptyList()) {
            return (B)this;
        }
        ListIterator<Component> listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            BuildableComponent<?, ?> buildableComponent;
            Component component = listIterator.next();
            if (!(component instanceof BuildableComponent) || component == (buildableComponent = Objects.requireNonNull(function.apply((BuildableComponent)component), "mappedChild"))) continue;
            listIterator.set(buildableComponent);
        }
        return (B)this;
    }

    @Override
    @NotNull
    public B mapChildrenDeep(@NotNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> function) {
        if (this.children == Collections.emptyList()) {
            return (B)this;
        }
        ListIterator<Component> listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            Object object = listIterator.next();
            if (!(object instanceof BuildableComponent)) continue;
            BuildableComponent<?, ?> buildableComponent = Objects.requireNonNull(function.apply((BuildableComponent)object), "mappedChild");
            if (buildableComponent.children().isEmpty()) {
                if (object == buildableComponent) continue;
                listIterator.set(buildableComponent);
                continue;
            }
            object = buildableComponent.toBuilder();
            object.mapChildrenDeep(function);
            listIterator.set((Component)object.build());
        }
        return (B)this;
    }

    @Override
    @NotNull
    public List<Component> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    @NotNull
    public B style(@NotNull Style style) {
        this.style = style;
        this.styleBuilder = null;
        return (B)this;
    }

    @Override
    @NotNull
    public B style(@NotNull Consumer<Style.Builder> consumer) {
        consumer.accept(this.styleBuilder());
        return (B)this;
    }

    @Override
    @NotNull
    public B font(@Nullable Key key) {
        this.styleBuilder().font(key);
        return (B)this;
    }

    @Override
    @NotNull
    public B color(@Nullable TextColor textColor) {
        this.styleBuilder().color(textColor);
        return (B)this;
    }

    @Override
    @NotNull
    public B colorIfAbsent(@Nullable TextColor textColor) {
        this.styleBuilder().colorIfAbsent(textColor);
        return (B)this;
    }

    @Override
    @NotNull
    public B shadowColor(@Nullable ARGBLike aRGBLike) {
        this.styleBuilder().shadowColor(aRGBLike);
        return (B)this;
    }

    @Override
    @NotNull
    public B shadowColorIfAbsent(@Nullable ARGBLike aRGBLike) {
        this.styleBuilder().shadowColorIfAbsent(aRGBLike);
        return (B)this;
    }

    @Override
    @NotNull
    public B decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
        this.styleBuilder().decoration(textDecoration, state);
        return (B)this;
    }

    @Override
    @NotNull
    public B decorationIfAbsent(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
        this.styleBuilder().decorationIfAbsent(textDecoration, state);
        return (B)this;
    }

    @Override
    @NotNull
    public B clickEvent(@Nullable ClickEvent clickEvent) {
        this.styleBuilder().clickEvent(clickEvent);
        return (B)this;
    }

    @Override
    @NotNull
    public B hoverEvent(@Nullable HoverEventSource<?> hoverEventSource) {
        this.styleBuilder().hoverEvent((HoverEventSource)hoverEventSource);
        return (B)this;
    }

    @Override
    @NotNull
    public B insertion(@Nullable String string) {
        this.styleBuilder().insertion(string);
        return (B)this;
    }

    @Override
    @NotNull
    public B mergeStyle(@NotNull Component styleGetter, @NotNull Set<Style.Merge> set) {
        if ((styleGetter = Objects.requireNonNull(styleGetter, "that").style()).isEmpty() && set.isEmpty()) {
            return (B)this;
        }
        this.styleBuilder().merge((Style)styleGetter, set);
        return (B)this;
    }

    @Override
    @NotNull
    public B resetStyle() {
        this.style = null;
        this.styleBuilder = null;
        return (B)this;
    }

    private @NotNull Style.Builder styleBuilder() {
        if (this.styleBuilder == null) {
            if (this.style != null) {
                this.styleBuilder = this.style.toBuilder();
                this.style = null;
            } else {
                this.styleBuilder = Style.style();
            }
        }
        return this.styleBuilder;
    }

    protected final boolean hasStyle() {
        return this.styleBuilder != null || this.style != null;
    }

    @NotNull
    protected Style buildStyle() {
        if (this.styleBuilder != null) {
            return this.styleBuilder.build();
        }
        if (this.style != null) {
            return this.style;
        }
        return Style.empty();
    }
}

