/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.sound;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.builder.AbstractBuilder;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Key;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.key.Keyed;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.sound.SoundImpl;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.sound.SoundStop;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.util.Index;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.NonExtendable
public interface Sound
extends Examinable {
    @NotNull
    public static Builder sound() {
        return new SoundImpl.BuilderImpl();
    }

    @NotNull
    public static Builder sound(@NotNull Sound sound) {
        return new SoundImpl.BuilderImpl(sound);
    }

    @NotNull
    public static Sound sound(@NotNull Consumer<Builder> consumer) {
        return (Sound)AbstractBuilder.configureAndBuild(Sound.sound(), consumer);
    }

    @NotNull
    public static Sound sound(@NotNull Key key, @NotNull Source source, float f2, float f3) {
        return (Sound)Sound.sound().type(key).source(source).volume(f2).pitch(f3).build();
    }

    @NotNull
    public static Sound sound(@NotNull Type type, @NotNull Source source, float f2, float f3) {
        Objects.requireNonNull(type, "type");
        return Sound.sound(type.key(), source, f2, f3);
    }

    @NotNull
    public static Sound sound(@NotNull Supplier<? extends Type> supplier, @NotNull Source source, float f2, float f3) {
        return (Sound)Sound.sound().type(supplier).source(source).volume(f2).pitch(f3).build();
    }

    @NotNull
    public static Sound sound(@NotNull Key key, @NotNull Source.Provider provider, float f2, float f3) {
        return Sound.sound(key, provider.soundSource(), f2, f3);
    }

    @NotNull
    public static Sound sound(@NotNull Type type, @NotNull Source.Provider provider, float f2, float f3) {
        return Sound.sound(type, provider.soundSource(), f2, f3);
    }

    @NotNull
    public static Sound sound(@NotNull Supplier<? extends Type> supplier, @NotNull Source.Provider provider, float f2, float f3) {
        return Sound.sound(supplier, provider.soundSource(), f2, f3);
    }

    @NotNull
    public Key name();

    @NotNull
    public Source source();

    public float volume();

    public float pitch();

    @NotNull
    public OptionalLong seed();

    @NotNull
    public SoundStop asStop();

    public static interface Builder
    extends AbstractBuilder<Sound> {
        @NotNull
        public Builder type(@NotNull Key var1);

        @NotNull
        public Builder type(@NotNull Type var1);

        @NotNull
        public Builder type(@NotNull Supplier<? extends Type> var1);

        @NotNull
        public Builder source(@NotNull Source var1);

        @NotNull
        public Builder source(@NotNull Source.Provider var1);

        @NotNull
        public Builder volume(@Range(from=0L, to=0x7FFFFFFFL) float var1);

        @NotNull
        public Builder pitch(@Range(from=-1L, to=1L) float var1);

        @NotNull
        public Builder seed(long var1);

        @NotNull
        public Builder seed(@NotNull OptionalLong var1);
    }

    public static enum Source {
        MASTER("master"),
        MUSIC("music"),
        RECORD("record"),
        WEATHER("weather"),
        BLOCK("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYER("player"),
        AMBIENT("ambient"),
        VOICE("voice"),
        UI("ui");

        public static final Index<String, Source> NAMES;
        private final String name;

        private Source(String string2) {
            this.name = string2;
        }

        static {
            NAMES = Index.create(Source.class, source -> source.name);
        }

        public static interface Provider {
            @NotNull
            public Source soundSource();
        }
    }

    public static interface Type
    extends Keyed {
        @Override
        @NotNull
        public Key key();
    }

    public static interface Emitter {
        @NotNull
        public static Emitter self() {
            return SoundImpl.EMITTER_SELF;
        }
    }
}

