/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.pointer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.pointer.Pointer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.pointer.Pointers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PointersImpl
implements Pointers {
    static final Pointers EMPTY = new Pointers(){

        @Override
        @NotNull
        public <T> Optional<T> get(@NotNull Pointer<T> pointer) {
            return Optional.empty();
        }

        @Override
        public <T> boolean supports(@NotNull Pointer<T> pointer) {
            return false;
        }

        @Override
        public @NotNull Pointers.Builder toBuilder() {
            return new BuilderImpl();
        }

        public String toString() {
            return "EmptyPointers";
        }
    };
    private final Map<Pointer<?>, Supplier<?>> pointers;

    PointersImpl(@NotNull BuilderImpl builderImpl) {
        this.pointers = new HashMap(builderImpl.pointers);
    }

    @Override
    @NotNull
    public final <T> Optional<T> get(@NotNull Pointer<T> object) {
        Objects.requireNonNull(object, "pointer");
        object = this.pointers.get(object);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(object.get());
    }

    @Override
    public final <T> boolean supports(@NotNull Pointer<T> pointer) {
        Objects.requireNonNull(pointer, "pointer");
        return this.pointers.containsKey(pointer);
    }

    @Override
    public final @NotNull Pointers.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements Pointers.Builder {
        private final Map<Pointer<?>, Supplier<?>> pointers;

        BuilderImpl() {
            this.pointers = new HashMap();
        }

        BuilderImpl(@NotNull PointersImpl pointersImpl) {
            this.pointers = new HashMap(pointersImpl.pointers);
        }

        @Override
        @NotNull
        public final <T> Pointers.Builder withDynamic(@NotNull Pointer<T> pointer, @NotNull Supplier<@Nullable T> supplier) {
            this.pointers.put(Objects.requireNonNull(pointer, "pointer"), Objects.requireNonNull(supplier, "value"));
            return this;
        }

        @Override
        @NotNull
        public final Pointers build() {
            return new PointersImpl(this);
        }
    }
}

