/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.bukkit;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MinecraftReflection {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String PREFIX_NMS = "net.minecraft.server";
    private static final String PREFIX_MC = "net.minecraft.";
    private static final String PREFIX_CRAFTBUKKIT = "org.bukkit.craftbukkit";
    private static final String CRAFT_SERVER = "CraftServer";
    @Nullable
    private static final String VERSION;

    private MinecraftReflection() {
    }

    @Nullable
    public static Class<?> findClass(String ... stringArray) {
        for (String object : stringArray) {
            if (object == null) continue;
            try {
                Class<?> clazz = Class.forName(object);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    @NotNull
    public static Class<?> needClass(String ... stringArray) {
        return Objects.requireNonNull(MinecraftReflection.findClass(stringArray), "Could not find class from candidates" + Arrays.toString(stringArray));
    }

    public static boolean hasClass(String ... stringArray) {
        return MinecraftReflection.findClass(stringArray) != null;
    }

    @Nullable
    public static MethodHandle findMethod(@Nullable Class<?> clazz, String string, @Nullable Class<?> clazz2, Class<?> ... classArray) {
        return MinecraftReflection.findMethod(clazz, new String[]{string}, clazz2, classArray);
    }

    @Nullable
    public static MethodHandle findMethod(@Nullable Class<?> clazz, @Nullable String @NotNull [] stringArray, @Nullable Class<?> clazz2, Class<?> ... classArray) {
        Object object;
        int n2;
        if (clazz == null || clazz2 == null) {
            return null;
        }
        Object[] objectArray = classArray;
        int n3 = classArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = objectArray[n2];
            if (object != null) continue;
            return null;
        }
        objectArray = stringArray;
        n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = objectArray[n2];
            if (object == null) continue;
            try {
                return LOOKUP.findVirtual(clazz, (String)object, MethodType.methodType(clazz2, classArray));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        }
        return null;
    }

    public static MethodHandle searchMethod(@Nullable Class<?> clazz, @Nullable Integer n2, String string, @Nullable Class<?> clazz2, Class<?> ... classArray) {
        return MinecraftReflection.searchMethod(clazz, n2, new String[]{string}, clazz2, classArray);
    }

    public static MethodHandle searchMethod(@Nullable Class<?> clazz, @Nullable Integer n2, @Nullable String @NotNull [] stringArray, @Nullable Class<?> clazz2, Class<?> ... classArray) {
        int n3;
        if (clazz == null || clazz2 == null) {
            return null;
        }
        Object[] objectArray = classArray;
        int n4 = classArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            Class<?> object2 = objectArray[n3];
            if (object2 != null) continue;
            return null;
        }
        objectArray = stringArray;
        n4 = stringArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            Object object = objectArray[n3];
            if (object == null) continue;
            try {
                if (n2 != null && Modifier.isStatic(n2)) {
                    return LOOKUP.findStatic(clazz, (String)object, MethodType.methodType(clazz2, classArray));
                }
                return LOOKUP.findVirtual(clazz, (String)object, MethodType.methodType(clazz2, classArray));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (n2 == null || (method.getModifiers() & n2) == 0 || !Arrays.equals(method.getParameterTypes(), classArray)) continue;
            try {
                if (Modifier.isStatic(n2)) {
                    return LOOKUP.findStatic(clazz, method.getName(), MethodType.methodType(clazz2, classArray));
                }
                return LOOKUP.findVirtual(clazz, method.getName(), MethodType.methodType(clazz2, classArray));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        }
        return null;
    }

    @Nullable
    public static MethodHandle findStaticMethod(@Nullable Class<?> clazz, String string, @Nullable Class<?> clazz2, Class<?> ... classArray) {
        return MinecraftReflection.findStaticMethod(clazz, new String[]{string}, clazz2, classArray);
    }

    @Nullable
    public static MethodHandle findStaticMethod(@Nullable Class<?> clazz, String[] stringArray, @Nullable Class<?> clazz2, Class<?> ... classArray) {
        Class<?> clazz3;
        int n2;
        if (clazz == null || clazz2 == null) {
            return null;
        }
        Object[] objectArray = classArray;
        int n3 = classArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            clazz3 = objectArray[n2];
            if (clazz3 != null) continue;
            return null;
        }
        objectArray = stringArray;
        n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            clazz3 = objectArray[n2];
            try {
                return LOOKUP.findStatic(clazz, (String)((Object)clazz3), MethodType.methodType(clazz2, classArray));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                continue;
            }
        }
        return null;
    }

    public static boolean hasField(@Nullable Class<?> clazz, Class<?> clazz2, String ... stringArray) {
        if (clazz == null) {
            return false;
        }
        for (String string : stringArray) {
            try {
                Field field = clazz.getDeclaredField(string);
                if (field.getType() != clazz2) continue;
                return true;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return false;
    }

    public static boolean hasMethod(@Nullable Class<?> clazz, String string, Class<?> ... classArray) {
        return MinecraftReflection.hasMethod(clazz, new String[]{string}, classArray);
    }

    public static boolean hasMethod(@Nullable Class<?> clazz, String[] stringArray, Class<?> ... classArray) {
        Class<?> clazz2;
        int n2;
        if (clazz == null) {
            return false;
        }
        Object[] objectArray = classArray;
        int n3 = classArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            clazz2 = objectArray[n2];
            if (clazz2 != null) continue;
            return false;
        }
        objectArray = stringArray;
        n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            clazz2 = objectArray[n2];
            try {
                clazz.getMethod((String)((Object)clazz2), classArray);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return false;
    }

    @Nullable
    public static MethodHandle findConstructor(@Nullable Class<?> clazz, Class<?> ... classArray) {
        if (clazz == null) {
            return null;
        }
        Class<?>[] classArray2 = classArray;
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz2 = classArray2[i2];
            if (clazz2 != null) continue;
            return null;
        }
        try {
            return LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, classArray));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    @NotNull
    public static Field needField(@NotNull Class<?> annotatedElement, @NotNull String string) {
        annotatedElement = annotatedElement.getDeclaredField(string);
        ((Field)annotatedElement).setAccessible(true);
        return annotatedElement;
    }

    @Nullable
    public static Field findField(@Nullable Class<?> clazz, String ... stringArray) {
        return MinecraftReflection.findField(clazz, null, stringArray);
    }

    @Nullable
    public static Field findField(@Nullable Class<?> clazz, @Nullable Class<?> clazz2, String ... object) {
        if (clazz == null) {
            return null;
        }
        String[] stringArray = object;
        int n2 = ((String[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = stringArray[i2];
            try {
                object = clazz.getDeclaredField((String)object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            ((Field)object).setAccessible(true);
            if (clazz2 != null && !clazz2.isAssignableFrom(((Field)object).getType())) continue;
            return object;
        }
        return null;
    }

    @Nullable
    public static MethodHandle findSetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Nullable
    public static MethodHandle findGetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectGetter(field);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Nullable
    public static Object findEnum(@Nullable Class<?> clazz, @NotNull String string) {
        return MinecraftReflection.findEnum(clazz, string, Integer.MAX_VALUE);
    }

    @Nullable
    public static Object findEnum(@Nullable Class<?> objArray, @NotNull String string, int n2) {
        if (objArray == null || !Enum.class.isAssignableFrom((Class<?>)objArray)) {
            return null;
        }
        try {
            return Enum.valueOf(objArray.asSubclass(Enum.class), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objArray = objArray.getEnumConstants();
            if (objArray.length > n2) {
                return objArray[n2];
            }
            return null;
        }
    }

    public static boolean isCraftBukkit() {
        return VERSION != null;
    }

    @Nullable
    public static String findCraftClassName(@NotNull String string) {
        if (MinecraftReflection.isCraftBukkit()) {
            return PREFIX_CRAFTBUKKIT + VERSION + string;
        }
        return null;
    }

    @Nullable
    public static Class<?> findCraftClass(@NotNull String string) {
        if ((string = MinecraftReflection.findCraftClassName(string)) == null) {
            return null;
        }
        return MinecraftReflection.findClass(string);
    }

    @Nullable
    public static <T> Class<? extends T> findCraftClass(@NotNull String object, @NotNull Class<T> clazz) {
        if ((object = MinecraftReflection.findCraftClass((String)object)) == null || !Objects.requireNonNull(clazz, "superClass").isAssignableFrom((Class<?>)object)) {
            return null;
        }
        return ((Class)object).asSubclass(clazz);
    }

    @NotNull
    public static Class<?> needCraftClass(@NotNull String string) {
        return Objects.requireNonNull(MinecraftReflection.findCraftClass(string), "Could not find org.bukkit.craftbukkit class " + string);
    }

    @Nullable
    public static String findNmsClassName(@NotNull String string) {
        if (MinecraftReflection.isCraftBukkit()) {
            return PREFIX_NMS + VERSION + string;
        }
        return null;
    }

    @Nullable
    public static Class<?> findNmsClass(@NotNull String string) {
        if ((string = MinecraftReflection.findNmsClassName(string)) == null) {
            return null;
        }
        return MinecraftReflection.findClass(string);
    }

    @NotNull
    public static Class<?> needNmsClass(@NotNull String string) {
        return Objects.requireNonNull(MinecraftReflection.findNmsClass(string), "Could not find net.minecraft.server class " + string);
    }

    @Nullable
    public static String findMcClassName(@NotNull String string) {
        if (MinecraftReflection.isCraftBukkit()) {
            return PREFIX_MC + string;
        }
        return null;
    }

    @Nullable
    public static Class<?> findMcClass(String ... stringArray) {
        for (String string : stringArray) {
            Class<?> clazz;
            String string2 = MinecraftReflection.findMcClassName(string);
            if (string2 == null || (clazz = MinecraftReflection.findClass(string2)) == null) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public static Class<?> needMcClass(String ... stringArray) {
        return Objects.requireNonNull(MinecraftReflection.findMcClass(stringArray), "Could not find net.minecraft class from candidates" + Arrays.toString(stringArray));
    }

    public static @NotNull MethodHandles.Lookup lookup() {
        return LOOKUP;
    }

    static {
        Class<?> clazz = Bukkit.getServer().getClass();
        if (!clazz.getSimpleName().equals(CRAFT_SERVER)) {
            VERSION = null;
        } else if (clazz.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            VERSION = ".";
        } else {
            clazz = clazz.getName();
            clazz = ((String)((Object)clazz)).substring(22);
            clazz = ((String)((Object)clazz)).substring(0, ((String)((Object)clazz)).length() - 11);
            VERSION = clazz;
        }
    }
}

