/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.bukkit;

import com.google.common.collect.ImmutableList;
import com.google.common.graph.MutableGraph;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.audience.Audience;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.identity.Identity;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.bukkit.BukkitAudience;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.bukkit.BukkitAudiences;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.bukkit.BukkitComponentSerializer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.bukkit.MinecraftReflection;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.facet.FacetAudienceProvider;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.platform.facet.Knob;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.pointer.Pointered;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.flattener.ComponentFlattener;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.text.renderer.ComponentRenderer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.translation.GlobalTranslator;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

final class BukkitAudiencesImpl
extends FacetAudienceProvider<CommandSender, BukkitAudience>
implements BukkitAudiences,
Listener {
    private static final Map<String, BukkitAudiences> INSTANCES;
    private final Plugin plugin;

    static Builder builder(@NotNull Plugin plugin) {
        return new Builder(plugin);
    }

    static BukkitAudiences instanceFor(@NotNull Plugin plugin) {
        return BukkitAudiencesImpl.builder(plugin).build();
    }

    BukkitAudiencesImpl(@NotNull Plugin object, @NotNull ComponentRenderer<Pointered> player2) {
        super((ComponentRenderer<Pointered>)player2);
        this.plugin = Objects.requireNonNull(object, "plugin");
        object = this.plugin.getServer().getConsoleSender();
        this.addViewer(object);
        for (Player player2 : this.plugin.getServer().getOnlinePlayers()) {
            this.addViewer(player2);
        }
        this.registerEvent(PlayerJoinEvent.class, EventPriority.LOWEST, playerJoinEvent -> this.addViewer(playerJoinEvent.getPlayer()));
        this.registerEvent(PlayerQuitEvent.class, EventPriority.MONITOR, playerQuitEvent -> this.removeViewer(playerQuitEvent.getPlayer()));
    }

    @Override
    @NotNull
    public final Audience sender(@NotNull CommandSender commandSender) {
        while (true) {
            if (commandSender instanceof Player) {
                return this.player((Player)commandSender);
            }
            if (commandSender instanceof ConsoleCommandSender) {
                return this.console();
            }
            if (!(commandSender instanceof ProxiedCommandSender)) break;
            commandSender = ((ProxiedCommandSender)commandSender).getCallee();
        }
        if (commandSender instanceof Entity || commandSender instanceof Block) {
            return Audience.empty();
        }
        return this.createAudience(Collections.singletonList(commandSender));
    }

    @Override
    @NotNull
    public final Audience player(@NotNull Player player) {
        return super.player(player.getUniqueId());
    }

    @Override
    @NotNull
    protected final BukkitAudience createAudience(@NotNull Collection<CommandSender> collection) {
        return new BukkitAudience(this.plugin, this, collection);
    }

    @Override
    public final void close() {
        INSTANCES.remove(this.plugin.getName());
        super.close();
    }

    @Override
    @NotNull
    public final ComponentFlattener flattener() {
        return BukkitComponentSerializer.FLATTENER;
    }

    private <T extends Event> void registerEvent(@NotNull Class<T> clazz, @NotNull EventPriority eventPriority, @NotNull Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "callback");
        this.plugin.getServer().getPluginManager().registerEvent(clazz, (Listener)this, eventPriority, (listener, event) -> consumer.accept(event), this.plugin, true);
    }

    static {
        Knob.OUT = string -> Bukkit.getLogger().log(Level.INFO, (String)string);
        Knob.ERR = (string, throwable) -> Bukkit.getLogger().log(Level.WARNING, (String)string, (Throwable)throwable);
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
    }

    static final class Builder
    implements BukkitAudiences.Builder {
        @NotNull
        private final Plugin plugin;
        private ComponentRenderer<Pointered> componentRenderer;

        Builder(@NotNull Plugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.componentRenderer(pointered -> pointered.getOrDefault(Identity.LOCALE, DEFAULT_LOCALE), GlobalTranslator.renderer());
        }

        @Override
        @NotNull
        public final Builder componentRenderer(@NotNull ComponentRenderer<Pointered> componentRenderer) {
            this.componentRenderer = Objects.requireNonNull(componentRenderer, "component renderer");
            return this;
        }

        @Override
        public final @NotNull BukkitAudiences.Builder partition(@NotNull Function<Pointered, ?> function) {
            Objects.requireNonNull(function, "partitionFunction");
            return this;
        }

        @Override
        @NotNull
        public final BukkitAudiences build() {
            return INSTANCES.computeIfAbsent(this.plugin.getName(), string -> {
                this.softDepend("ViaVersion");
                return new BukkitAudiencesImpl(this.plugin, this.componentRenderer);
            });
        }

        private void softDepend(@NotNull String string) {
            Object object;
            Object object2;
            PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
            if (pluginDescriptionFile.getName().equals(string)) {
                return;
            }
            try {
                object2 = MinecraftReflection.needField(pluginDescriptionFile.getClass(), "softDepend");
                object = (List)((Field)object2).get(pluginDescriptionFile);
                if (!object.contains(string)) {
                    object = ImmutableList.builder().addAll((Iterable)object).add((Object)string).build();
                    ((Field)object2).set(pluginDescriptionFile, object);
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                Knob.logError(throwable, "Failed to inject softDepend in plugin.yml: %s %s", this.plugin, string);
            }
            try {
                object2 = this.plugin.getServer().getPluginManager();
                object = MinecraftReflection.needField(object2.getClass(), "dependencyGraph");
                object = (MutableGraph)((Field)object).get(object2);
                object.putEdge((Object)pluginDescriptionFile.getName(), (Object)string);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }
}

