/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Objects;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CharBuffer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.StringTagParseException;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.TagStringReader;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.TagStringWriter;
import org.jetbrains.annotations.NotNull;

public final class TagStringIO {
    private static final TagStringIO INSTANCE = new TagStringIO(new Builder());
    private final boolean acceptLegacy;
    private final boolean emitLegacy;
    private final boolean acceptHeterogeneousLists;
    private final boolean emitHeterogeneousLists;
    private final String indent;

    @Deprecated
    @NotNull
    public static TagStringIO get() {
        return TagStringIO.tagStringIO();
    }

    @NotNull
    public static TagStringIO tagStringIO() {
        return INSTANCE;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private TagStringIO(@NotNull Builder builder) {
        this.acceptLegacy = builder.acceptLegacy;
        this.emitLegacy = builder.emitLegacy;
        this.acceptHeterogeneousLists = builder.acceptHeterogeneousLists;
        this.emitHeterogeneousLists = builder.emitHeterogeneousLists;
        this.indent = builder.indent;
    }

    @NotNull
    public final CompoundBinaryTag asCompound(@NotNull String object) {
        Objects.requireNonNull(object, "input");
        try {
            object = new CharBuffer((CharSequence)object);
            Object object2 = new TagStringReader((CharBuffer)object);
            ((TagStringReader)object2).legacy(this.acceptLegacy);
            ((TagStringReader)object2).heterogeneousLists(this.acceptHeterogeneousLists);
            object2 = ((TagStringReader)object2).compound();
            if (((CharBuffer)object).skipWhitespace().hasMore()) {
                throw new IOException("Document had trailing content after first CompoundTag");
            }
            return object2;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    @NotNull
    public final BinaryTag asTag(@NotNull String object) {
        Objects.requireNonNull(object, "input");
        try {
            object = new CharBuffer((CharSequence)object);
            Object object2 = new TagStringReader((CharBuffer)object);
            ((TagStringReader)object2).legacy(this.acceptLegacy);
            ((TagStringReader)object2).heterogeneousLists(this.acceptHeterogeneousLists);
            object2 = ((TagStringReader)object2).tag();
            if (((CharBuffer)object).skipWhitespace().hasMore()) {
                throw new IOException("Document had trailing content after first Tag");
            }
            return object2;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    @NotNull
    public final CompoundBinaryTag asCompound(@NotNull String object, @NotNull Appendable appendable) {
        Objects.requireNonNull(object, "input");
        Objects.requireNonNull(appendable, "remainder");
        try {
            object = new CharBuffer((CharSequence)object);
            Object object2 = new TagStringReader((CharBuffer)object);
            ((TagStringReader)object2).legacy(this.acceptLegacy);
            ((TagStringReader)object2).heterogeneousLists(this.acceptHeterogeneousLists);
            object2 = ((TagStringReader)object2).compound();
            appendable.append(((CharBuffer)object).takeRest());
            return object2;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    @NotNull
    public final BinaryTag asTag(@NotNull String object, @NotNull Appendable appendable) {
        Objects.requireNonNull(object, "input");
        Objects.requireNonNull(appendable, "remainder");
        try {
            object = new CharBuffer((CharSequence)object);
            Object object2 = new TagStringReader((CharBuffer)object);
            ((TagStringReader)object2).legacy(this.acceptLegacy);
            ((TagStringReader)object2).heterogeneousLists(this.acceptHeterogeneousLists);
            object2 = ((TagStringReader)object2).tag();
            appendable.append(((CharBuffer)object).takeRest());
            return object2;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    @NotNull
    public final String asString(@NotNull CompoundBinaryTag compoundBinaryTag) {
        return this.asString((BinaryTag)compoundBinaryTag);
    }

    @NotNull
    public final String asString(@NotNull BinaryTag binaryTag) {
        Objects.requireNonNull(binaryTag, "input");
        StringBuilder stringBuilder = new StringBuilder();
        try (TagStringWriter tagStringWriter = new TagStringWriter(stringBuilder, this.indent);){
            tagStringWriter.legacy(this.emitLegacy);
            tagStringWriter.heterogeneousLists(this.emitHeterogeneousLists);
            tagStringWriter.writeTag(binaryTag);
        }
        return stringBuilder.toString();
    }

    public final void toWriter(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull Writer writer) {
        this.toWriter((BinaryTag)compoundBinaryTag, writer);
    }

    public final void toWriter(@NotNull BinaryTag binaryTag, @NotNull Writer autoCloseable) {
        Objects.requireNonNull(binaryTag, "input");
        Objects.requireNonNull(autoCloseable, "dest");
        autoCloseable = new TagStringWriter((Appendable)((Object)autoCloseable), this.indent);
        try {
            ((TagStringWriter)autoCloseable).legacy(this.emitLegacy);
            ((TagStringWriter)autoCloseable).heterogeneousLists(this.emitHeterogeneousLists);
            ((TagStringWriter)autoCloseable).writeTag(binaryTag);
            return;
        }
        finally {
            ((TagStringWriter)autoCloseable).close();
        }
    }

    public static class Builder {
        private boolean acceptLegacy = true;
        private boolean emitLegacy = false;
        private boolean acceptHeterogeneousLists = false;
        private boolean emitHeterogeneousLists = false;
        private String indent = "";

        Builder() {
        }

        @NotNull
        public Builder indent(int n2) {
            if (n2 == 0) {
                this.indent = "";
            } else if (!this.indent.isEmpty() && this.indent.charAt(0) != ' ' || n2 != this.indent.length()) {
                char[] cArray = new char[n2];
                Arrays.fill(cArray, ' ');
                this.indent = String.copyValueOf(cArray);
            }
            return this;
        }

        @NotNull
        public Builder indentTab(int n2) {
            if (n2 == 0) {
                this.indent = "";
            } else if (!this.indent.isEmpty() && this.indent.charAt(0) != '\t' || n2 != this.indent.length()) {
                char[] cArray = new char[n2];
                Arrays.fill(cArray, '\t');
                this.indent = String.copyValueOf(cArray);
            }
            return this;
        }

        @NotNull
        public Builder acceptLegacy(boolean bl) {
            this.acceptLegacy = bl;
            return this;
        }

        @NotNull
        public Builder emitLegacy(boolean bl) {
            this.emitLegacy = bl;
            return this;
        }

        @NotNull
        public Builder acceptHeterogeneousLists(boolean bl) {
            this.acceptHeterogeneousLists = bl;
            return this;
        }

        @NotNull
        public Builder emitHeterogeneousLists(boolean bl) {
            this.emitHeterogeneousLists = bl;
            return this;
        }

        @NotNull
        public TagStringIO build() {
            return new TagStringIO(this);
        }
    }
}

