/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CompoundBinaryTagImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompoundTagBuilder
implements CompoundBinaryTag.Builder {
    private static final int DEFAULT_CAPACITY = -1;
    @Nullable
    private Map<String, BinaryTag> tags;
    private final int initialCapacity;

    CompoundTagBuilder() {
        this(-1);
    }

    CompoundTagBuilder(int n2) {
        this.initialCapacity = n2;
    }

    private Map<String, BinaryTag> tags() {
        if (this.tags == null) {
            if (this.initialCapacity != -1) {
                if (this.initialCapacity < 0) {
                    throw new IllegalArgumentException("initialCapacity cannot be less than 0, was " + this.initialCapacity);
                }
                this.tags = new HashMap<String, BinaryTag>(this.initialCapacity);
            } else {
                this.tags = new HashMap<String, BinaryTag>();
            }
        }
        return this.tags;
    }

    @Override
    public final @NotNull CompoundBinaryTag.Builder put(@NotNull String string, @NotNull BinaryTag binaryTag) {
        this.tags().put(string, binaryTag);
        return this;
    }

    @Override
    public final @NotNull CompoundBinaryTag.Builder put(@NotNull CompoundBinaryTag compoundBinaryTag) {
        Map<String, BinaryTag> map = this.tags();
        for (String string : compoundBinaryTag.keySet()) {
            map.put(string, compoundBinaryTag.get(string));
        }
        return this;
    }

    @Override
    public final @NotNull CompoundBinaryTag.Builder put(@NotNull Map<String, ? extends BinaryTag> map) {
        this.tags().putAll(map);
        return this;
    }

    @Override
    public final @NotNull CompoundBinaryTag.Builder remove(@NotNull String object, @Nullable Consumer<? super BinaryTag> consumer) {
        if (this.tags != null) {
            object = this.tags.remove(object);
            if (consumer != null) {
                consumer.accept((BinaryTag)object);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public final CompoundBinaryTag build() {
        if (this.tags == null) {
            return CompoundBinaryTag.empty();
        }
        return new CompoundBinaryTagImpl(new HashMap<String, BinaryTag>(this.tags));
    }
}

