/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.AbstractBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTagType;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTagTypes;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.ByteArrayBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.IntArrayBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.ListBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.LongArrayBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.NumberBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.StringBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"CompoundBinaryTag[length=\" + this.tags.size() + \"]\"", childrenArray="this.tags.entrySet().toArray()", hasChildren="!this.tags.isEmpty()")
final class CompoundBinaryTagImpl
extends AbstractBinaryTag
implements CompoundBinaryTag {
    static final CompoundBinaryTag EMPTY = new CompoundBinaryTagImpl(Collections.emptyMap());
    private final Map<String, BinaryTag> tags;
    private final int hashCode;

    CompoundBinaryTagImpl(Map<String, BinaryTag> map) {
        this.tags = Collections.unmodifiableMap(map);
        this.hashCode = map.hashCode();
    }

    @Override
    public final boolean contains(@NotNull String string) {
        return this.tags.containsKey(string);
    }

    @Override
    public final boolean contains(@NotNull String object, @NotNull BinaryTagType<?> binaryTagType) {
        return (object = this.tags.get(Objects.requireNonNull(object, "key"))) != null && Objects.requireNonNull(binaryTagType, "type").test(object.type());
    }

    @Override
    @NotNull
    public final Set<String> keySet() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    @Override
    @Nullable
    public final BinaryTag get(String string) {
        return this.tags.get(string);
    }

    @Override
    public final int size() {
        return this.tags.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    @NotNull
    public final CompoundBinaryTag put(@NotNull String string, @NotNull BinaryTag binaryTag) {
        return this.edit(map -> map.put(string, binaryTag));
    }

    @Override
    @NotNull
    public final CompoundBinaryTag put(@NotNull CompoundBinaryTag compoundBinaryTag) {
        return this.edit(map -> {
            for (String string : compoundBinaryTag.keySet()) {
                map.put(string, compoundBinaryTag.get(string));
            }
        });
    }

    @Override
    @NotNull
    public final CompoundBinaryTag put(@NotNull Map<String, ? extends BinaryTag> map) {
        return this.edit(map2 -> map2.putAll(map));
    }

    @Override
    @NotNull
    public final CompoundBinaryTag remove(@NotNull String string, @Nullable Consumer<? super BinaryTag> consumer) {
        if (!this.tags.containsKey(string)) {
            return this;
        }
        return this.edit(map -> {
            string = (BinaryTag)map.remove(string);
            if (consumer != null) {
                consumer.accept((BinaryTag)((Object)string));
            }
        });
    }

    @Override
    public final byte getByte(@NotNull String string, byte by) {
        if (this.contains(string, BinaryTagTypes.BYTE)) {
            return ((NumberBinaryTag)this.tags.get(string)).byteValue();
        }
        return by;
    }

    @Override
    public final short getShort(@NotNull String string, short s2) {
        if (this.contains(string, BinaryTagTypes.SHORT)) {
            return ((NumberBinaryTag)this.tags.get(string)).shortValue();
        }
        return s2;
    }

    @Override
    public final int getInt(@NotNull String string, int n2) {
        if (this.contains(string, BinaryTagTypes.INT)) {
            return ((NumberBinaryTag)this.tags.get(string)).intValue();
        }
        return n2;
    }

    @Override
    public final long getLong(@NotNull String string, long l2) {
        if (this.contains(string, BinaryTagTypes.LONG)) {
            return ((NumberBinaryTag)this.tags.get(string)).longValue();
        }
        return l2;
    }

    @Override
    public final float getFloat(@NotNull String string, float f2) {
        if (this.contains(string, BinaryTagTypes.FLOAT)) {
            return ((NumberBinaryTag)this.tags.get(string)).floatValue();
        }
        return f2;
    }

    @Override
    public final double getDouble(@NotNull String string, double d2) {
        if (this.contains(string, BinaryTagTypes.DOUBLE)) {
            return ((NumberBinaryTag)this.tags.get(string)).doubleValue();
        }
        return d2;
    }

    @Override
    public final byte @NotNull [] getByteArray(@NotNull String string) {
        if (this.contains(string, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(string)).value();
        }
        return new byte[0];
    }

    @Override
    public final byte @NotNull [] getByteArray(@NotNull String string, byte @NotNull [] byArray) {
        if (this.contains(string, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(string)).value();
        }
        return byArray;
    }

    @Override
    @NotNull
    public final String getString(@NotNull String string, @NotNull String string2) {
        if (this.contains(string, BinaryTagTypes.STRING)) {
            return ((StringBinaryTag)this.tags.get(string)).value();
        }
        return string2;
    }

    @Override
    @NotNull
    public final ListBinaryTag getList(@NotNull String string, @NotNull ListBinaryTag listBinaryTag) {
        if (this.contains(string, BinaryTagTypes.LIST)) {
            return (ListBinaryTag)this.tags.get(string);
        }
        return listBinaryTag;
    }

    @Override
    @NotNull
    public final ListBinaryTag getList(@NotNull String object, @NotNull BinaryTagType<? extends BinaryTag> binaryTagType, @NotNull ListBinaryTag listBinaryTag) {
        if (this.contains((String)object, BinaryTagTypes.LIST) && binaryTagType.test((object = (ListBinaryTag)this.tags.get(object)).elementType())) {
            return object;
        }
        return listBinaryTag;
    }

    @Override
    @NotNull
    public final CompoundBinaryTag getCompound(@NotNull String string, @NotNull CompoundBinaryTag compoundBinaryTag) {
        if (this.contains(string, BinaryTagTypes.COMPOUND)) {
            return (CompoundBinaryTag)this.tags.get(string);
        }
        return compoundBinaryTag;
    }

    @Override
    public final int @NotNull [] getIntArray(@NotNull String string) {
        if (this.contains(string, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(string)).value();
        }
        return new int[0];
    }

    @Override
    public final int @NotNull [] getIntArray(@NotNull String string, int @NotNull [] nArray) {
        if (this.contains(string, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(string)).value();
        }
        return nArray;
    }

    @Override
    public final long @NotNull [] getLongArray(@NotNull String string) {
        if (this.contains(string, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(string)).value();
        }
        return new long[0];
    }

    @Override
    public final long @NotNull [] getLongArray(@NotNull String string, long @NotNull [] lArray) {
        if (this.contains(string, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(string)).value();
        }
        return lArray;
    }

    @Override
    public final Stream<Map.Entry<String, ? extends BinaryTag>> stream() {
        return this.tags.entrySet().stream();
    }

    private CompoundBinaryTag edit(Consumer<Map<String, BinaryTag>> consumer) {
        HashMap<String, BinaryTag> hashMap = new HashMap<String, BinaryTag>(this.tags);
        consumer.accept(hashMap);
        return new CompoundBinaryTagImpl(new HashMap<String, BinaryTag>(hashMap));
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof CompoundBinaryTagImpl && this.tags.equals(((CompoundBinaryTagImpl)object).tags);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags));
    }

    @Override
    @NotNull
    public final Iterator<Map.Entry<String, ? extends BinaryTag>> iterator() {
        return this.tags.entrySet().iterator();
    }

    @Override
    public final void forEach(@NotNull Consumer<? super Map.Entry<String, ? extends BinaryTag>> consumer) {
        this.tags.entrySet().forEach(Objects.requireNonNull(consumer, "action"));
    }
}

