/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTagIO;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTagType;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.BinaryTagTypes;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.IOStreamUtil;
import me.loving11ish.clientdetectorplus.libs.adventure.adventure.nbt.TrackingDataInput;
import org.jetbrains.annotations.NotNull;

final class BinaryTagReaderImpl
implements BinaryTagIO.Reader {
    private final long maxBytes;
    static final BinaryTagIO.Reader UNLIMITED = new BinaryTagReaderImpl(-1L);
    static final BinaryTagIO.Reader DEFAULT_LIMIT = new BinaryTagReaderImpl(131082L);

    BinaryTagReaderImpl(long l2) {
        this.maxBytes = l2;
    }

    @Override
    @NotNull
    public final CompoundBinaryTag read(@NotNull Path object, @NotNull BinaryTagIO.Compression object2) {
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        try {
            object2 = this.read((InputStream)object, (BinaryTagIO.Compression)object2);
            return object2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    @Override
    @NotNull
    public final CompoundBinaryTag read(@NotNull InputStream inputStream, @NotNull BinaryTagIO.Compression object) {
        inputStream = new DataInputStream(new BufferedInputStream(((BinaryTagIO.Compression)object).decompress(IOStreamUtil.closeShield(inputStream))));
        try {
            object = this.read((DataInput)((Object)inputStream));
            return object;
        }
        finally {
            ((FilterInputStream)inputStream).close();
        }
    }

    @Override
    @NotNull
    public final CompoundBinaryTag read(@NotNull DataInput dataInput) {
        return this.read(dataInput, true);
    }

    @NotNull
    private CompoundBinaryTag read(@NotNull DataInput dataInput, boolean bl) {
        if (!(dataInput instanceof TrackingDataInput)) {
            dataInput = new TrackingDataInput(dataInput, this.maxBytes);
        }
        BinaryTagType<BinaryTag> binaryTagType = BinaryTagType.binaryTagType(dataInput.readByte());
        BinaryTagReaderImpl.requireCompound(binaryTagType);
        if (bl) {
            DataInput dataInput2 = dataInput;
            dataInput2.skipBytes(dataInput2.readUnsignedShort());
        }
        return BinaryTagTypes.COMPOUND.read(dataInput);
    }

    @Override
    @NotNull
    public final CompoundBinaryTag readNameless(@NotNull Path object, @NotNull BinaryTagIO.Compression object2) {
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        try {
            object2 = this.readNameless((InputStream)object, (BinaryTagIO.Compression)object2);
            return object2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    @Override
    @NotNull
    public final CompoundBinaryTag readNameless(@NotNull InputStream inputStream, @NotNull BinaryTagIO.Compression object) {
        inputStream = new DataInputStream(new BufferedInputStream(((BinaryTagIO.Compression)object).decompress(IOStreamUtil.closeShield(inputStream))));
        try {
            object = this.readNameless((DataInput)((Object)inputStream));
            return object;
        }
        finally {
            ((FilterInputStream)inputStream).close();
        }
    }

    @Override
    @NotNull
    public final CompoundBinaryTag readNameless(@NotNull DataInput dataInput) {
        return this.read(dataInput, false);
    }

    @Override
    public final  @NotNull Map.Entry<String, CompoundBinaryTag> readNamed(@NotNull Path object, @NotNull BinaryTagIO.Compression object2) {
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        try {
            object2 = this.readNamed((InputStream)object, (BinaryTagIO.Compression)object2);
            return object2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    @Override
    public final  @NotNull Map.Entry<String, CompoundBinaryTag> readNamed(@NotNull InputStream inputStream, @NotNull BinaryTagIO.Compression object) {
        inputStream = new DataInputStream(new BufferedInputStream(((BinaryTagIO.Compression)object).decompress(IOStreamUtil.closeShield(inputStream))));
        try {
            object = this.readNamed((DataInput)((Object)inputStream));
            return object;
        }
        finally {
            ((FilterInputStream)inputStream).close();
        }
    }

    @Override
    public final  @NotNull Map.Entry<String, CompoundBinaryTag> readNamed(@NotNull DataInput dataInput) {
        Object object = BinaryTagType.binaryTagType(dataInput.readByte());
        BinaryTagReaderImpl.requireCompound(object);
        object = dataInput.readUTF();
        return new AbstractMap.SimpleImmutableEntry<Object, CompoundBinaryTag>(object, BinaryTagTypes.COMPOUND.read(dataInput));
    }

    private static void requireCompound(BinaryTagType<? extends BinaryTag> binaryTagType) {
        if (binaryTagType != BinaryTagTypes.COMPOUND) {
            throw new IOException(String.format("Expected root tag to be a %s, was %s", BinaryTagTypes.COMPOUND, binaryTagType));
        }
    }
}

