/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.option;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.loving11ish.clans.libs.adventure.option.Option;
import me.loving11ish.clans.libs.adventure.option.OptionImpl;
import me.loving11ish.clans.libs.adventure.option.OptionSchema;
import me.loving11ish.clans.libs.adventure.option.OptionState;
import me.loving11ish.clans.libs.adventure.option.OptionStateImpl;
import me.loving11ish.clans.libs.adventure.option.value.ValueType;

final class OptionSchemaImpl
implements OptionSchema {
    final OptionState emptyState;
    final ConcurrentMap<String, Option<?>> options = new ConcurrentHashMap();

    OptionSchemaImpl(OptionSchemaImpl optionSchemaImpl) {
        if (optionSchemaImpl != null) {
            this.options.putAll(optionSchemaImpl.options);
        }
        this.emptyState = new OptionStateImpl(this, new IdentityHashMap());
    }

    @Override
    public final Set<Option<?>> knownOptions() {
        return Collections.unmodifiableSet(new HashSet(this.options.values()));
    }

    @Override
    public final boolean has(Option<?> option) {
        Option option2 = (Option)this.options.get(option.id());
        return option2 != null && option2.equals(option);
    }

    @Override
    public final OptionState.Builder stateBuilder() {
        return new OptionStateImpl.BuilderImpl(this);
    }

    @Override
    public final OptionState.VersionedBuilder versionedStateBuilder() {
        return new OptionStateImpl.VersionedBuilderImpl(this);
    }

    @Override
    public final OptionState emptyState() {
        return this.emptyState;
    }

    public final String toString() {
        return "OptionSchemaImpl{options=" + this.options + '}';
    }

    final class MutableImpl
    implements OptionSchema.Mutable {
        MutableImpl() {
        }

        final <T> Option<T> register(String string, ValueType<T> optionImpl, T t2) {
            optionImpl = new OptionImpl<T>(Objects.requireNonNull(string, "id"), Objects.requireNonNull(optionImpl, "type"), t2);
            if (OptionSchemaImpl.this.options.putIfAbsent(string, optionImpl) != null) {
                throw new IllegalStateException("Key " + string + " has already been used. Option keys must be unique within a schema.");
            }
            return optionImpl;
        }

        @Override
        public final Option<String> stringOption(String string, String string2) {
            return this.register(string, ValueType.stringType(), string2);
        }

        @Override
        public final Option<Boolean> booleanOption(String string, boolean bl) {
            return this.register(string, ValueType.booleanType(), bl);
        }

        @Override
        public final Option<Integer> intOption(String string, int n2) {
            return this.register(string, ValueType.integerType(), n2);
        }

        @Override
        public final Option<Double> doubleOption(String string, double d2) {
            return this.register(string, ValueType.doubleType(), d2);
        }

        @Override
        public final <E extends Enum<E>> Option<E> enumOption(String string, Class<E> clazz, E e2) {
            return this.register(string, ValueType.enumType(clazz), e2);
        }

        @Override
        public final OptionSchema frozenView() {
            return OptionSchemaImpl.this;
        }

        @Override
        public final Set<Option<?>> knownOptions() {
            return OptionSchemaImpl.this.knownOptions();
        }

        @Override
        public final boolean has(Option<?> option) {
            return OptionSchemaImpl.this.has(option);
        }

        @Override
        public final OptionState.Builder stateBuilder() {
            return OptionSchemaImpl.this.stateBuilder();
        }

        @Override
        public final OptionState.VersionedBuilder versionedStateBuilder() {
            return OptionSchemaImpl.this.versionedStateBuilder();
        }

        @Override
        public final OptionState emptyState() {
            return OptionSchemaImpl.this.emptyState();
        }

        public final String toString() {
            return "MutableImpl{schema=" + OptionSchemaImpl.this + "}";
        }
    }

    static final class Instances {
        static MutableImpl GLOBAL = new OptionSchemaImpl(null).new MutableImpl();

        Instances() {
        }
    }
}

