/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.examination.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.examination.AbstractExaminer;
import me.loving11ish.clans.libs.adventure.examination.string.StringExaminer;
import me.loving11ish.clans.libs.adventure.examination.string.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineStringExaminer
extends AbstractExaminer<Stream<String>> {
    private static final String INDENT_2 = "  ";
    private final StringExaminer examiner;

    @NotNull
    public static MultiLineStringExaminer simpleEscaping() {
        return Instances.SIMPLE_ESCAPING;
    }

    public MultiLineStringExaminer(@NotNull StringExaminer stringExaminer) {
        this.examiner = stringExaminer;
    }

    @Override
    @NotNull
    protected <E> Stream<String> array(E @NotNull [] EArray, @NotNull Stream<Stream<String>> stream) {
        return this.arrayLike(stream);
    }

    @Override
    @NotNull
    protected <E> Stream<String> collection(@NotNull Collection<E> collection, @NotNull Stream<Stream<String>> stream) {
        return this.arrayLike(stream);
    }

    @Override
    @NotNull
    protected Stream<String> examinable(@NotNull String string, @NotNull Stream<Map.Entry<String, Stream<String>>> stream) {
        stream = MultiLineStringExaminer.flatten(",", stream.map(entry -> MultiLineStringExaminer.association((Stream<String>)this.examine((String)entry.getKey()), " = ", (Stream)entry.getValue())));
        stream = MultiLineStringExaminer.indent(stream);
        return MultiLineStringExaminer.enclose(stream, string + "{", "}");
    }

    @Override
    @NotNull
    protected <K, V> Stream<String> map(@NotNull Map<K, V> stream, @NotNull Stream<Map.Entry<Stream<String>, Stream<String>>> stream2) {
        stream = MultiLineStringExaminer.flatten(",", stream2.map(entry -> MultiLineStringExaminer.association((Stream)entry.getKey(), " = ", (Stream)entry.getValue())));
        stream = MultiLineStringExaminer.indent(stream);
        return MultiLineStringExaminer.enclose(stream, "{", "}");
    }

    @Override
    @NotNull
    protected Stream<String> nil() {
        return Stream.of(this.examiner.nil());
    }

    @Override
    @NotNull
    protected Stream<String> scalar(@NotNull Object object) {
        return Stream.of(this.examiner.scalar(object));
    }

    @Override
    @NotNull
    public Stream<String> examine(boolean bl) {
        return Stream.of(this.examiner.examine(bl));
    }

    @Override
    @NotNull
    public Stream<String> examine(byte by) {
        return Stream.of(this.examiner.examine(by));
    }

    @Override
    @NotNull
    public Stream<String> examine(char c2) {
        return Stream.of(this.examiner.examine(c2));
    }

    @Override
    @NotNull
    public Stream<String> examine(double d2) {
        return Stream.of(this.examiner.examine(d2));
    }

    @Override
    @NotNull
    public Stream<String> examine(float f2) {
        return Stream.of(this.examiner.examine(f2));
    }

    @Override
    @NotNull
    public Stream<String> examine(int n2) {
        return Stream.of(this.examiner.examine(n2));
    }

    @Override
    @NotNull
    public Stream<String> examine(long l2) {
        return Stream.of(this.examiner.examine(l2));
    }

    @Override
    @NotNull
    public Stream<String> examine(short s2) {
        return Stream.of(this.examiner.examine(s2));
    }

    @Override
    @NotNull
    protected Stream<String> array(int n2, IntFunction<Stream<String>> intFunction) {
        return this.arrayLike(n2 == 0 ? Stream.empty() : IntStream.range(0, n2).mapToObj(intFunction));
    }

    @Override
    @NotNull
    protected <T> Stream<String> stream(@NotNull Stream<T> stream) {
        return this.arrayLike(stream.map(this::examine));
    }

    @Override
    @NotNull
    protected Stream<String> stream(@NotNull DoubleStream doubleStream) {
        return this.arrayLike(doubleStream.mapToObj(d2 -> this.examine(d2)));
    }

    @Override
    @NotNull
    protected Stream<String> stream(@NotNull IntStream intStream) {
        return this.arrayLike(intStream.mapToObj(n2 -> this.examine(n2)));
    }

    @Override
    @NotNull
    protected Stream<String> stream(@NotNull LongStream longStream) {
        return this.arrayLike(longStream.mapToObj(l2 -> this.examine(l2)));
    }

    @Override
    @NotNull
    public Stream<String> examine(@Nullable String string) {
        return Stream.of(this.examiner.examine(string));
    }

    private Stream<String> arrayLike(Stream<Stream<String>> stream) {
        stream = MultiLineStringExaminer.flatten(",", stream);
        stream = MultiLineStringExaminer.indent(stream);
        return MultiLineStringExaminer.enclose(stream, "[", "]");
    }

    private static Stream<String> enclose(Stream<String> stream, String string, String string2) {
        return MultiLineStringExaminer.enclose(stream.collect(Collectors.toList()), string, string2);
    }

    private static Stream<String> enclose(List<String> list, String string, String string2) {
        if (list.isEmpty()) {
            return Stream.of(string + string2);
        }
        return Stream.of(Stream.of(string), MultiLineStringExaminer.indent(list.stream()), Stream.of(string2)).reduce(Stream.empty(), Stream::concat);
    }

    private static Stream<String> flatten(String string, Stream<Stream<String>> stream2) {
        ArrayList arrayList = new ArrayList();
        stream2.forEachOrdered(stream -> {
            if (!arrayList.isEmpty()) {
                int n2 = arrayList.size() - 1;
                arrayList.set(n2, (String)arrayList.get(n2) + string);
            }
            stream.forEachOrdered(arrayList::add);
        });
        return arrayList.stream();
    }

    private static Stream<String> association(Stream<String> stream, String string, Stream<String> stream2) {
        return MultiLineStringExaminer.association(stream.collect(Collectors.toList()), string, stream2.collect(Collectors.toList()));
    }

    private static Stream<String> association(List<String> list, String string, List<String> list2) {
        int n2 = list.size();
        int n3 = list2.size();
        int n4 = Math.max(n2, n3);
        int n5 = Strings.maxLength(list.stream());
        String string2 = n2 < 2 ? "" : Strings.repeat(" ", n5);
        String string3 = n2 < 2 ? "" : Strings.repeat(" ", string.length());
        ArrayList<String> arrayList = new ArrayList<String>(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            String string4 = i2 < n2 ? Strings.padEnd(list.get(i2), n5, ' ') : string2;
            String string5 = i2 == 0 ? string : string3;
            String string6 = i2 < n3 ? list2.get(i2) : "";
            arrayList.add(string4 + string5 + string6);
        }
        return arrayList.stream();
    }

    private static Stream<String> indent(Stream<String> stream) {
        return stream.map(string -> INDENT_2 + string);
    }

    private static final class Instances {
        static final MultiLineStringExaminer SIMPLE_ESCAPING = new MultiLineStringExaminer(StringExaminer.simpleEscaping());

        private Instances() {
        }
    }
}

