/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.util;

import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.util.HSVLikeImpl;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface HSVLike
extends Examinable {
    @NotNull
    public static HSVLike hsvLike(float f2, float f3, float f4) {
        return new HSVLikeImpl(f2, f3, f4);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @NotNull
    public static HSVLike of(float f2, float f3, float f4) {
        return new HSVLikeImpl(f2, f3, f4);
    }

    @NotNull
    public static HSVLike fromRGB(@Range(from=0L, to=255L) int n2, @Range(from=0L, to=255L) int n3, @Range(from=0L, to=255L) int n4) {
        float f2;
        float f3 = (float)n2 / 255.0f;
        float f4 = (float)n3 / 255.0f;
        float f5 = (float)n4 / 255.0f;
        float f6 = Math.min(f3, Math.min(f4, f5));
        float f7 = Math.max(f3, Math.max(f4, f5));
        f6 = f7 - f6;
        float f8 = f7 != 0.0f ? f6 / f7 : 0.0f;
        if (f8 == 0.0f) {
            return new HSVLikeImpl(0.0f, f8, f7);
        }
        f3 = f3 == f7 ? (f4 - f5) / f6 : (f4 == f7 ? 2.0f + (f5 - f3) / f6 : 4.0f + (f3 - f4) / f6);
        f3 *= 60.0f;
        if (f2 < 0.0f) {
            f3 += 360.0f;
        }
        return new HSVLikeImpl(f3 / 360.0f, f8, f7);
    }

    public float h();

    public float s();

    public float v();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("h", this.h()), ExaminableProperty.of("s", this.s()), ExaminableProperty.of("v", this.v()));
    }
}

