/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.standard;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.standard.GradientTag;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PrideTag
extends GradientTag {
    private static final String PRIDE = "pride";
    static final TagResolver RESOLVER = TagResolver.resolver("pride", PrideTag::create);
    private static final Map<String, List<TextColor>> FLAGS;
    private final String flag;

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        double d2 = 0.0;
        String string = PRIDE;
        if (argumentQueue.hasNext()) {
            String string2 = argumentQueue.pop().value().toLowerCase(Locale.ROOT);
            if (FLAGS.containsKey(string2)) {
                string = string2;
            } else if (!string2.isEmpty()) {
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw context.newException("Expected phase, got " + string2);
                }
                if (d2 < -1.0 || d2 > 1.0) {
                    throw context.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0, 1.0] (inclusive).", d2), argumentQueue);
                }
            }
        }
        return new PrideTag(d2, FLAGS.get(string), string, context);
    }

    PrideTag(double d2, @NotNull @NotNull List<@NotNull TextColor> list, @NotNull String string, Context context) {
        super(d2, list, context);
        this.flag = string;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("flag", this.flag), ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.flag, this.phase);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (PrideTag)object;
        return this.phase == ((PrideTag)object).phase && this.flag.equals(((PrideTag)object).flag);
    }

    @NotNull
    private static List<TextColor> colors(int ... nArray) {
        return Arrays.stream(nArray).mapToObj(TextColor::color).collect(Collectors.toList());
    }

    static {
        HashMap<String, List<TextColor>> hashMap = new HashMap<String, List<TextColor>>();
        hashMap.put(PRIDE, PrideTag.colors(0xE50000, 16747776, 0xFFEE00, 164129, 19711, 0x770088));
        hashMap.put("progress", PrideTag.colors(0xFFFFFF, 16756679, 7591918, 6371605, 0, 0xE50000, 16747776, 0xFFEE00, 164129, 19711, 0x770088));
        hashMap.put("trans", PrideTag.colors(6017019, 16100281, 0xFFFFFF, 16100281, 6017019));
        hashMap.put("bi", PrideTag.colors(14025328, 10178454, 14504));
        hashMap.put("pan", PrideTag.colors(16718989, 16766720, 1750015));
        hashMap.put("nb", PrideTag.colors(16577585, 0xFCFCFC, 10312146, 0x282828));
        hashMap.put("lesbian", PrideTag.colors(14034944, 16751446, 0xFFFFFF, 13918886, 10748002));
        hashMap.put("ace", PrideTag.colors(0, 0xA4A4A4, 0xFFFFFF, 0x810081));
        hashMap.put("agender", PrideTag.colors(0, 0xBABABA, 0xFFFFFF, 12252292, 0xFFFFFF, 0xBABABA, 0));
        hashMap.put("demisexual", PrideTag.colors(0, 0xFFFFFF, 7209073, 0xD3D3D3));
        hashMap.put("genderqueer", PrideTag.colors(11894749, 0xFFFFFF, 4817438));
        hashMap.put("genderfluid", PrideTag.colors(16676514, 0xFFFFFF, 12522199, 0, 3161278));
        hashMap.put("intersex", PrideTag.colors(16766976, 7930538, 16766976));
        hashMap.put("aro", PrideTag.colors(3909440, 11064442, 0xFFFFFF, 0xABABAB, 0));
        hashMap.put("baker", PrideTag.colors(13461247, 16737689, 0xFE0000, 16685312, 0xFFFF01, 39168, 39371, 3473561, 0x990099));
        hashMap.put("philly", PrideTag.colors(0, 7884567, 0xFE0000, 16616448, 16770304, 1154827, 410803, 12725980));
        hashMap.put("queer", PrideTag.colors(0, 10148330, 41960, 11920669, 0xFFFFFF, 16763149, 16541287, 16690889, 0));
        hashMap.put("gay", PrideTag.colors(495216, 2543274, 10021057, 0xFFFFFF, 8105442, 5261771, 4004472));
        hashMap.put("bigender", PrideTag.colors(12876192, 15509195, 14010344, 0xFFFFFF, 14010344, 10143720, 7111631));
        hashMap.put("demigender", PrideTag.colors(0x7F7F7F, 0xC3C3C3, 16514932, 0xFFFFFF, 16514932, 0xC3C3C3, 0x7F7F7F));
        FLAGS = Collections.unmodifiableMap(hashMap);
    }
}

