/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.standard;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.loving11ish.clans.libs.adventure.adventure.key.InvalidKeyException;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.adventure.key.Keyed;
import me.loving11ish.clans.libs.adventure.adventure.nbt.api.BinaryTagHolder;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.event.DataComponentValue;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.StyleClaim;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverTag {
    private static final String HOVER = "hover";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("hover", HoverTag::create, StyleClaim.claim("hover", Style::hoverEvent, HoverTag::emit));

    private HoverTag() {
    }

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        Object object = argumentQueue.popOr("Hover event requires an action as its first argument").value();
        ActionHandler<?> actionHandler = HoverTag.actionHandler(object = HoverEvent.Action.NAMES.value((String)object));
        if (actionHandler == null) {
            throw context.newException("Don't know how to turn '" + argumentQueue + "' into a hover event", argumentQueue);
        }
        return Tag.styling(HoverEvent.hoverEvent(object, actionHandler.parse(argumentQueue, context)));
    }

    static void emit(HoverEvent<?> hoverEvent, TokenEmitter tokenEmitter) {
        ActionHandler<?> actionHandler = HoverTag.actionHandler(hoverEvent.action());
        tokenEmitter.tag(HOVER).argument(HoverEvent.Action.NAMES.key(hoverEvent.action()));
        actionHandler.emit(hoverEvent.value(), tokenEmitter);
    }

    @Nullable
    static <V> ActionHandler<V> actionHandler(HoverEvent.Action<V> action) {
        ActionHandler<Component> actionHandler = null;
        if (action == HoverEvent.Action.SHOW_TEXT) {
            actionHandler = ShowText.INSTANCE;
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            actionHandler = ShowItem.INSTANCE;
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            actionHandler = ShowEntity.INSTANCE;
        }
        return actionHandler;
    }

    @NotNull
    static String compactAsString(@NotNull Key key) {
        if (key.namespace().equals("minecraft")) {
            return key.value();
        }
        return key.asString();
    }

    static interface ActionHandler<V> {
        @NotNull
        public V parse(@NotNull ArgumentQueue var1, @NotNull Context var2);

        public void emit(V var1, TokenEmitter var2);
    }

    static final class ShowText
    implements ActionHandler<Component> {
        private static final ShowText INSTANCE = new ShowText();

        private ShowText() {
        }

        @Override
        @NotNull
        public final Component parse(@NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
            return context.deserialize(argumentQueue.popOr("show_text action requires a message").value());
        }

        @Override
        public final void emit(Component component, TokenEmitter tokenEmitter) {
            tokenEmitter.argument(component);
        }
    }

    static final class ShowItem
    implements ActionHandler<HoverEvent.ShowItem> {
        private static final ShowItem INSTANCE = new ShowItem();

        private ShowItem() {
        }

        @Override
        public final @NotNull HoverEvent.ShowItem parse(@NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
            try {
                int n2;
                Key key = Key.key(argumentQueue.popOr("Show item hover needs at least an item ID").value());
                int n3 = n2 = argumentQueue.hasNext() ? argumentQueue.pop().asInt().orElseThrow(() -> context.newException("The count argument was not a valid integer")) : 1;
                if (argumentQueue.hasNext()) {
                    Object object = argumentQueue.peek().value();
                    if (((String)object).startsWith("{")) {
                        argumentQueue.pop();
                        return ShowItem.legacyShowItem(key, n2, (String)object);
                    }
                    object = new HashMap();
                    while (argumentQueue.hasNext()) {
                        Key key2 = Key.key(argumentQueue.pop().value());
                        String string = argumentQueue.popOr("a value was expected for key " + key2).value();
                        object.put(key2, BinaryTagHolder.binaryTagHolder(string));
                    }
                    return HoverEvent.ShowItem.showItem((Keyed)key, n2, (Map<Key, ? extends DataComponentValue>)object);
                }
                return HoverEvent.ShowItem.showItem(key, n2);
            }
            catch (NumberFormatException | InvalidKeyException runtimeException) {
                throw context.newException("Exception parsing show_item hover", runtimeException, argumentQueue);
            }
        }

        private static @NotNull HoverEvent.ShowItem legacyShowItem(Key key, int n2, String string) {
            return HoverEvent.ShowItem.showItem(key, n2, BinaryTagHolder.binaryTagHolder(string));
        }

        @Override
        public final void emit(HoverEvent.ShowItem object, TokenEmitter tokenEmitter) {
            tokenEmitter.argument(HoverTag.compactAsString(((HoverEvent.ShowItem)((Object)object)).item()));
            if (((HoverEvent.ShowItem)((Object)object)).count() != 1 || ShowItem.hasLegacy((HoverEvent.ShowItem)((Object)object)) || !((HoverEvent.ShowItem)((Object)object)).dataComponents().isEmpty()) {
                tokenEmitter.argument(Integer.toString(((HoverEvent.ShowItem)((Object)object)).count()));
                if (ShowItem.hasLegacy((HoverEvent.ShowItem)((Object)object))) {
                    ShowItem.emitLegacyHover((HoverEvent.ShowItem)((Object)object), tokenEmitter);
                    return;
                }
                for (Map.Entry<Key, DataComponentValue.TagSerializable> entry : ((HoverEvent.ShowItem)((Object)object)).dataComponentsAs(DataComponentValue.TagSerializable.class).entrySet()) {
                    tokenEmitter.argument(entry.getKey().asMinimalString());
                    tokenEmitter.argument(entry.getValue().asBinaryTag().string());
                }
            }
        }

        static boolean hasLegacy(HoverEvent.ShowItem showItem) {
            return showItem.nbt() != null;
        }

        static void emitLegacyHover(HoverEvent.ShowItem showItem, TokenEmitter tokenEmitter) {
            if (showItem.nbt() != null) {
                tokenEmitter.argument(showItem.nbt().string());
            }
        }
    }

    static final class ShowEntity
    implements ActionHandler<HoverEvent.ShowEntity> {
        static final ShowEntity INSTANCE = new ShowEntity();

        private ShowEntity() {
        }

        @Override
        public final @NotNull HoverEvent.ShowEntity parse(@NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
            try {
                Key key = Key.key(argumentQueue.popOr("Show entity needs a type argument").value());
                UUID uUID = UUID.fromString(argumentQueue.popOr("Show entity needs an entity UUID").value());
                if (argumentQueue.hasNext()) {
                    Component component = context.deserialize(argumentQueue.pop().value());
                    return HoverEvent.ShowEntity.showEntity(key, uUID, component);
                }
                return HoverEvent.ShowEntity.showEntity(key, uUID);
            }
            catch (IllegalArgumentException | InvalidKeyException runtimeException) {
                throw context.newException("Exception parsing show_entity hover", runtimeException, argumentQueue);
            }
        }

        @Override
        public final void emit(HoverEvent.ShowEntity showEntity, TokenEmitter tokenEmitter) {
            tokenEmitter.argument(HoverTag.compactAsString(showEntity.type())).argument(showEntity.id().toString());
            if (showEntity.name() != null) {
                tokenEmitter.argument(showEntity.name());
            }
        }
    }
}

